/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.BalanceStrategy;
import com.gbase.jdbc.ConnectionGroup;
import com.gbase.jdbc.ConnectionGroupManager;
import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.GBaseConnection;
import com.gbase.jdbc.LoadBalanceExceptionChecker;
import com.gbase.jdbc.LoadBalancedGBaseConnection;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.NonRegisteringDriver;
import com.gbase.jdbc.PingTarget;
import com.gbase.jdbc.SQLError;
import com.gbase.jdbc.Statement;
import com.gbase.jdbc.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancingConnectionProxy
implements InvocationHandler,
PingTarget {
    private static Method getLocalTimeMethod;
    private long totalPhysicalConnections = 0L;
    private long activePhysicalConnections = 0L;
    private String hostToRemove = null;
    private long lastUsed = 0L;
    private long transactionCount = 0L;
    private ConnectionGroup connectionGroup = null;
    public static final String BLACKLIST_TIMEOUT_PROPERTY_KEY = "loadBalanceBlacklistTimeout";
    protected GBaseConnection currentConn;
    protected List<String> hostList;
    protected Map<String, ConnectionImpl> liveConnections;
    private Map<ConnectionImpl, String> connectionsToHostsMap;
    private long[] responseTimes;
    private Map<String, Integer> hostsToListIndexMap;
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private Properties localProps;
    private boolean isClosed = false;
    private BalanceStrategy balancer;
    private int retriesAllDown;
    private static Map<String, Long> globalBlacklist;
    private int globalBlacklistTimeout = 0;
    private long connectionGroupProxyID = 0L;
    private LoadBalanceExceptionChecker exceptionChecker;
    private Map<Class, Boolean> jdbcInterfacesForProxyCache = new HashMap<Class, Boolean>();
    private GBaseConnection thisAsConnection = null;
    private Map<Class, Class[]> allInterfacesToProxy = new HashMap<Class, Class[]>();

    LoadBalancingConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        String group = props.getProperty("loadBalanceConnectionGroup", null);
        boolean enableJMX = false;
        String enableJMXAsString = props.getProperty("loadBalanceEnableJMX", "false");
        try {
            enableJMX = Boolean.parseBoolean(enableJMXAsString);
        }
        catch (Exception e) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceEnableJMX", new Object[]{enableJMXAsString}), "S1009", null);
        }
        if (group != null) {
            this.connectionGroup = ConnectionGroupManager.getConnectionGroupInstance(group);
            if (enableJMX) {
                ConnectionGroupManager.registerJmx();
            }
            this.connectionGroupProxyID = this.connectionGroup.registerConnectionProxy(this, hosts);
            hosts = new ArrayList<String>(this.connectionGroup.getInitialHosts());
        }
        this.hostList = hosts;
        int numHosts = this.hostList.size();
        this.liveConnections = new HashMap<String, ConnectionImpl>(numHosts);
        this.connectionsToHostsMap = new HashMap<ConnectionImpl, String>(numHosts);
        this.responseTimes = new long[numHosts];
        this.hostsToListIndexMap = new HashMap<String, Integer>(numHosts);
        this.localProps = (Properties)props.clone();
        this.localProps.remove("HOST");
        this.localProps.remove("PORT");
        for (int i = 0; i < numHosts; ++i) {
            this.hostsToListIndexMap.put(this.hostList.get(i), new Integer(i));
            this.localProps.remove("HOST." + (i + 1));
            this.localProps.remove("PORT." + (i + 1));
        }
        this.localProps.remove("NUM_HOSTS");
        this.localProps.setProperty("useLocalSessionState", "true");
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        String lbExceptionChecker = this.localProps.getProperty("loadBalanceExceptionChecker", "com.gbase.jdbc.StandardLoadBalanceExceptionChecker");
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        String blacklistTimeoutAsString = this.localProps.getProperty(BLACKLIST_TIMEOUT_PROPERTY_KEY, "0");
        try {
            this.globalBlacklistTimeout = Integer.parseInt(blacklistTimeoutAsString);
        }
        catch (NumberFormatException nfe) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancingConnectionProxy.badValueForLoadBalanceBlacklistTimeout", new Object[]{retriesAllDownAsString}), "S1009", null);
        }
        this.balancer = "random".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.gbase.jdbc.RandomBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0) : ("bestResponseTime".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, "com.gbase.jdbc.BestResponseTimeBalanceStrategy", "InvalidLoadBalanceStrategy", null).get(0) : (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy", null).get(0));
        this.balancer.init(null, props);
        this.exceptionChecker = (LoadBalanceExceptionChecker)Util.loadExtensions(null, props, lbExceptionChecker, "InvalidLoadBalanceExceptionChecker", null).get(0);
        this.exceptionChecker.init(null, props);
        this.thisAsConnection = new LoadBalancedGBaseConnection(this);
        this.pickNewConnection();
    }

    public synchronized ConnectionImpl createConnectionForHost(String hostPortSpec) throws SQLException {
        Properties connProps = (Properties)this.localProps.clone();
        String[] hostPortPair = NonRegisteringDriver.parseHostPortPair(hostPortSpec);
        String hostName = hostPortPair[0];
        String portNumber = hostPortPair[1];
        String dbName = connProps.getProperty("DBNAME");
        if (hostName == null) {
            throw new SQLException("Could not find a hostname to start a connection to");
        }
        if (portNumber == null) {
            portNumber = "5258";
        }
        connProps.setProperty("HOST", hostName);
        connProps.setProperty("PORT", portNumber);
        connProps.setProperty("HOST.1", hostName);
        connProps.setProperty("PORT.1", portNumber);
        connProps.setProperty("NUM_HOSTS", "1");
        connProps.setProperty("roundRobinLoadBalance", "false");
        ConnectionImpl conn = (ConnectionImpl)ConnectionImpl.getInstance(hostName, Integer.parseInt(portNumber), connProps, dbName, "jdbc:gbase://" + hostName + ":" + portNumber + "/");
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        ++this.activePhysicalConnections;
        ++this.totalPhysicalConnections;
        conn.setProxy(this.thisAsConnection);
        return conn;
    }

    void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t = e.getTargetException();
        if (t != null) {
            if (t instanceof SQLException && this.shouldExceptionTriggerFailover((SQLException)t)) {
                this.invalidateCurrentConnection();
                this.pickNewConnection();
            }
            throw t;
        }
        throw e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void invalidateCurrentConnection() throws SQLException {
        try {
            if (!this.currentConn.isClosed()) {
                this.currentConn.close();
            }
            Object var2_1 = null;
            if (this.isGlobalBlacklistEnabled()) {
                this.addToGlobalBlacklist(this.connectionsToHostsMap.get(this.currentConn));
            }
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.isGlobalBlacklistEnabled()) {
                this.addToGlobalBlacklist(this.connectionsToHostsMap.get(this.currentConn));
            }
            this.liveConnections.remove(this.connectionsToHostsMap.get(this.currentConn));
            String mappedHost = this.connectionsToHostsMap.remove(this.currentConn);
            if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) throw throwable;
            int hostIndex = this.hostsToListIndexMap.get(mappedHost);
            long[] lArray = this.responseTimes;
            synchronized (this.responseTimes) {
                this.responseTimes[hostIndex] = 0L;
                // ** MonitorExit[var5_8] (shouldn't be in output)
                throw throwable;
            }
        }
        String mappedHost = this.connectionsToHostsMap.remove(this.currentConn);
        if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) return;
        int hostIndex = this.hostsToListIndexMap.get(mappedHost);
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = 0L;
            // ** MonitorExit[var5_7] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            Iterator<ConnectionImpl> allConnections = this.liveConnections.values().iterator();
            while (allConnections.hasNext()) {
                try {
                    --this.activePhysicalConnections;
                    allConnections.next().close();
                }
                catch (SQLException sQLException) {}
            }
            if (!this.isClosed) {
                this.balancer.destroy();
                if (this.connectionGroup != null) {
                    this.connectionGroup.closeConnectionProxy(this);
                }
            }
            this.liveConnections.clear();
            this.connectionsToHostsMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getLoadBalanceSafeProxy".equals(methodName)) {
            return this.currentConn;
        }
        if ("equals".equals(methodName) && args.length == 1) {
            if (!(args[0] instanceof Proxy)) return this.equals(args[0]);
            return ((Proxy)args[0]).equals(this);
        }
        if ("hashCode".equals(methodName)) {
            return new Integer(this.hashCode());
        }
        if ("close".equals(methodName)) {
            this.closeAllConnections();
            this.isClosed = true;
            return null;
        }
        if ("isClosed".equals(methodName)) {
            return this.isClosed;
        }
        if (this.isClosed) {
            throw SQLError.createSQLException("No operations allowed after connection closed.", "08003", null);
        }
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = LoadBalancingConnectionProxy.getLocalTimeBestResolution();
            ++this.transactionCount;
        }
        Object result = null;
        try {
            block25: {
                try {
                    this.lastUsed = System.currentTimeMillis();
                    result = method.invoke((Object)this.thisAsConnection, args);
                    if (result == null) break block25;
                    if (result instanceof Statement) {
                        ((Statement)result).setPingTarget(this);
                    }
                    result = this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
                catch (InvocationTargetException e) {
                    this.dealWithInvocationException(e);
                    Object var8_7 = null;
                    if (!"commit".equals(methodName)) {
                        if (!"rollback".equals(methodName)) return result;
                    }
                    this.inTransaction = false;
                    String host = this.connectionsToHostsMap.get(this.currentConn);
                    if (host != null) {
                        long[] lArray = this.responseTimes;
                        // MONITORENTER : this.responseTimes
                        int hostIndex = this.hostsToListIndexMap.get(host);
                        if (hostIndex < this.responseTimes.length) {
                            this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                        }
                        // MONITOREXIT : lArray
                    }
                    this.pickNewConnection();
                    return result;
                }
            }
            Object var8_6 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) return result;
            }
            this.inTransaction = false;
            String host = this.connectionsToHostsMap.get(this.currentConn);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                int hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            return result;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!"commit".equals(methodName)) {
                if (!"rollback".equals(methodName)) throw throwable;
            }
            this.inTransaction = false;
            String host = this.connectionsToHostsMap.get(this.currentConn);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                int hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex] = LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            throw throwable;
        }
    }

    protected synchronized void pickNewConnection() throws SQLException {
        if (this.currentConn == null) {
            this.currentConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            return;
        }
        if (this.currentConn.isClosed()) {
            this.invalidateCurrentConnection();
        }
        boolean currentAutoCommit = this.currentConn.getAutoCommit();
        int currentTransIsolation = this.currentConn.getTransactionIsolation();
        int pingTimeout = this.currentConn.getLoadBalancePingTimeout();
        boolean pingBeforeReturn = this.currentConn.getLoadBalanceValidateConnectionOnSwapServer();
        int hostsToTry = this.hostList.size();
        for (int hostsTried = 0; hostsTried <= hostsToTry; ++hostsTried) {
            try {
                ConnectionImpl newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
                if (this.currentConn != null) {
                    if (pingBeforeReturn) {
                        if (pingTimeout == 0) {
                            newConn.ping();
                        } else {
                            newConn.pingInternal(true, pingTimeout);
                        }
                    }
                    newConn.setTransactionIsolation(currentTransIsolation);
                    newConn.setAutoCommit(currentAutoCommit);
                }
                this.currentConn = newConn;
                return;
            }
            catch (SQLException e) {
                if (!this.shouldExceptionTriggerFailover(e)) continue;
                this.invalidateCurrentConnection();
                continue;
            }
        }
        this.isClosed = true;
    }

    Object proxyIfInterfaceIsJdbc(Object toProxy, Class clazz) {
        if (this.isInterfaceJdbc(clazz)) {
            Class[] interfacesToProxy = this.getAllInterfacesToProxy(clazz);
            return Proxy.newProxyInstance(toProxy.getClass().getClassLoader(), interfacesToProxy, (InvocationHandler)this.createConnectionProxy(toProxy));
        }
        return toProxy;
    }

    private Class[] getAllInterfacesToProxy(Class clazz) {
        Class[] interfacesToProxy = this.allInterfacesToProxy.get(clazz);
        if (interfacesToProxy != null) {
            return interfacesToProxy;
        }
        LinkedList interfaces = new LinkedList();
        Class superClass = clazz;
        while (!superClass.equals(Object.class)) {
            Class<?>[] declared = superClass.getInterfaces();
            for (int i = 0; i < declared.length; ++i) {
                interfaces.add(declared[i]);
            }
            superClass = superClass.getSuperclass();
        }
        interfacesToProxy = new Class[interfaces.size()];
        interfaces.toArray(interfacesToProxy);
        this.allInterfacesToProxy.put(clazz, interfacesToProxy);
        return interfacesToProxy;
    }

    private boolean isInterfaceJdbc(Class clazz) {
        if (this.jdbcInterfacesForProxyCache.containsKey(clazz)) {
            return this.jdbcInterfacesForProxyCache.get(clazz);
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            String packageName = interfaces[i].getPackage().getName();
            if ("java.sql".equals(packageName) || "javax.sql".equals(packageName) || "com.gbase.jdbc".equals(packageName)) {
                this.jdbcInterfacesForProxyCache.put(clazz, new Boolean(true));
                return true;
            }
            if (!this.isInterfaceJdbc(interfaces[i])) continue;
            this.jdbcInterfacesForProxyCache.put(clazz, new Boolean(true));
            return true;
        }
        this.jdbcInterfacesForProxyCache.put(clazz, new Boolean(false));
        return false;
    }

    protected ConnectionErrorFiringInvocationHandler createConnectionProxy(Object toProxy) {
        return new ConnectionErrorFiringInvocationHandler(toProxy);
    }

    private static long getLocalTimeBestResolution() {
        if (getLocalTimeMethod != null) {
            try {
                return (Long)getLocalTimeMethod.invoke(null, (Object[])null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void doPing() throws SQLException {
        SQLException se = null;
        boolean foundHost = false;
        int pingTimeout = this.currentConn.getLoadBalancePingTimeout();
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            for (String host : this.hostList) {
                ConnectionImpl conn = this.liveConnections.get(host);
                if (conn == null) continue;
                try {
                    if (pingTimeout == 0) {
                        conn.ping();
                    } else {
                        conn.pingInternal(true, pingTimeout);
                    }
                    foundHost = true;
                }
                catch (SQLException e) {
                    --this.activePhysicalConnections;
                    if (host.equals(this.connectionsToHostsMap.get(this.currentConn))) {
                        this.closeAllConnections();
                        this.isClosed = true;
                        throw e;
                    }
                    if (e.getMessage().equals(Messages.getString("Connection.exceededConnectionLifetime"))) {
                        if (se == null) {
                            se = e;
                        }
                    } else {
                        se = e;
                        if (this.isGlobalBlacklistEnabled()) {
                            this.addToGlobalBlacklist(host);
                        }
                    }
                    this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                }
            }
        }
        if (!foundHost) {
            this.closeAllConnections();
            this.isClosed = true;
            if (se != null) {
                throw se;
            }
            ((ConnectionImpl)this.currentConn).throwConnectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGlobalBlacklist(String host, long timeout) {
        if (this.isGlobalBlacklistEnabled()) {
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.put(host, new Long(timeout));
            }
        }
    }

    public void addToGlobalBlacklist(String host) {
        this.addToGlobalBlacklist(host, System.currentTimeMillis() + (long)this.globalBlacklistTimeout);
    }

    public boolean isGlobalBlacklistEnabled() {
        return this.globalBlacklistTimeout > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getGlobalBlacklist() {
        if (!this.isGlobalBlacklistEnabled()) {
            String localHostToRemove = this.hostToRemove;
            if (this.hostToRemove != null) {
                HashMap<String, Long> fakedBlacklist = new HashMap<String, Long>();
                fakedBlacklist.put(localHostToRemove, new Long(System.currentTimeMillis() + 5000L));
                return fakedBlacklist;
            }
            return new HashMap<String, Long>(1);
        }
        HashMap<String, Long> blacklistClone = new HashMap<String, Long>(globalBlacklist.size());
        Map<String, Long> fakedBlacklist = globalBlacklist;
        synchronized (fakedBlacklist) {
            blacklistClone.putAll(globalBlacklist);
        }
        Set keys = blacklistClone.keySet();
        keys.retainAll(this.hostList);
        if (keys.size() == this.hostList.size()) {
            return new HashMap<String, Long>(1);
        }
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String host = (String)i.next();
            Long timeout = globalBlacklist.get(host);
            if (timeout == null || timeout >= System.currentTimeMillis()) continue;
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.remove(host);
            }
            i.remove();
        }
        return blacklistClone;
    }

    public boolean shouldExceptionTriggerFailover(SQLException ex) {
        return this.exceptionChecker.shouldExceptionTriggerFailover(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostWhenNotInUse(String host) throws SQLException {
        int timeBetweenChecks = 1000;
        long timeBeforeHardFail = 15000L;
        this.addToGlobalBlacklist(host, timeBeforeHardFail + 1000L);
        long cur = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeBeforeHardFail < cur) {
            LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
            synchronized (loadBalancingConnectionProxy) {
                this.hostToRemove = host;
                if (!host.equals(this.currentConn.getHost())) {
                    this.removeHost(host);
                    return;
                }
            }
            try {
                Thread.sleep(timeBetweenChecks);
            }
            catch (InterruptedException e) {}
        }
        this.removeHost(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHost(String host) throws SQLException {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            if (this.connectionGroup != null && this.connectionGroup.getInitialHosts().size() == 1 && this.connectionGroup.getInitialHosts().contains(host)) {
                throw SQLError.createSQLException("Cannot remove only configured host.", null);
            }
            this.hostToRemove = host;
            if (host.equals(this.currentConn.getHost())) {
                this.closeAllConnections();
            } else {
                this.connectionsToHostsMap.remove(this.liveConnections.remove(host));
                Integer idx = this.hostsToListIndexMap.remove(host);
                long[] newResponseTimes = new long[this.responseTimes.length - 1];
                int newIdx = 0;
                for (String copyHost : this.hostList) {
                    if (idx != null && idx < this.responseTimes.length) {
                        newResponseTimes[newIdx] = this.responseTimes[idx];
                        this.hostsToListIndexMap.put(copyHost, new Integer(newIdx));
                    }
                    ++newIdx;
                }
                this.responseTimes = newResponseTimes;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addHost(String host) {
        LoadBalancingConnectionProxy loadBalancingConnectionProxy = this;
        synchronized (loadBalancingConnectionProxy) {
            if (this.hostsToListIndexMap.containsKey(host)) {
                return false;
            }
            long[] newResponseTimes = new long[this.responseTimes.length + 1];
            for (int i = 0; i < this.responseTimes.length; ++i) {
                newResponseTimes[i] = this.responseTimes[i];
            }
            this.responseTimes = newResponseTimes;
            this.hostList.add(host);
            this.hostsToListIndexMap.put(host, new Integer(this.responseTimes.length - 1));
        }
        return true;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public boolean inTransaction() {
        return this.inTransaction;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public long getActivePhysicalConnectionCount() {
        return this.activePhysicalConnections;
    }

    public long getTotalPhysicalConnectionCount() {
        return this.totalPhysicalConnections;
    }

    public long getConnectionGroupProxyID() {
        return this.connectionGroupProxyID;
    }

    public String getCurrentActiveHost() {
        String o;
        GBaseConnection c = this.currentConn;
        if (c != null && (o = this.connectionsToHostsMap.get(c)) != null) {
            return o.toString();
        }
        return null;
    }

    public long getCurrentTransactionDuration() {
        long st = 0L;
        if (this.inTransaction && (st = this.transactionStartTime) > 0L) {
            return LoadBalancingConnectionProxy.getLocalTimeBestResolution() - this.transactionStartTime;
        }
        return 0L;
    }

    static {
        try {
            getLocalTimeMethod = System.class.getMethod("nanoTime", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        globalBlacklist = new HashMap<String, Long>();
    }

    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                result = method.invoke(this.invokeOn, args);
                if (result != null) {
                    result = LoadBalancingConnectionProxy.this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException e) {
                LoadBalancingConnectionProxy.this.dealWithInvocationException(e);
            }
            return result;
        }
    }
}

