/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc.util;

import com.gbase.jdbc.TimeUtil;
import java.sql.DriverManager;
import java.sql.ResultSet;

public class TimezoneDump {
    private static final String DEFAULT_URL = "jdbc:gbase:///test";

    public static void main(String[] args) throws Exception {
        String jdbcUrl = DEFAULT_URL;
        if (args.length == 1 && args[0] != null) {
            jdbcUrl = args[0];
        }
        Class.forName("com.gbase.jdbc.Driver").newInstance();
        ResultSet rs = DriverManager.getConnection(jdbcUrl).createStatement().executeQuery("SHOW VARIABLES LIKE 'timezone'");
        while (rs.next()) {
            String timezoneFromServer = rs.getString(2);
            System.out.println("GBase timezone name: " + timezoneFromServer);
            String canonicalTimezone = TimeUtil.getCanoncialTimezone(timezoneFromServer, null);
            System.out.println("Java timezone name: " + canonicalTimezone);
        }
    }
}

