/*
 * Decompiled with CFR 0.152.
 */
package com.gbase.jdbc;

import com.gbase.jdbc.Connection;
import com.gbase.jdbc.ConnectionImpl;
import com.gbase.jdbc.GBaseErrForCluster;
import com.gbase.jdbc.GcGBaseLoadBalance;
import com.gbase.jdbc.GcGBaseLoadBalanceQueue;
import com.gbase.jdbc.Messages;
import com.gbase.jdbc.SQLError;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;

public class GcGBaseLoadBalanceConnection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.Connection getGcLoadBanceConnection(Properties props, String originalUrl) throws SQLException {
        String gclusterId = (String)props.get("gclusterId");
        Map map = GcGBaseLoadBalance.ipQueueTable;
        synchronized (map) {
            if (!GcGBaseLoadBalance.ipQueueTable.containsKey(gclusterId)) {
                GcGBaseLoadBalance.initClusterIpQueue(gclusterId, props, originalUrl);
            }
        }
        return this.getHeighAvailLoadBalanceConnection(gclusterId, props, originalUrl);
    }

    private SQLException createAllHostGoneAwayExecption(String gclusterId) {
        GcGBaseLoadBalanceQueue gcGBaseLoadBalanceQueue = GcGBaseLoadBalance.getGcGBaseLoadBalanceQueueByGcluster(gclusterId);
        SQLException sqlEx = SQLError.createSQLException(Messages.getString("NonRegisteringDriver.38") + gcGBaseLoadBalanceQueue.getBrokenQueue().toString() + Messages.getString("NonRegisteringDriver.18"), "08001", null);
        return sqlEx;
    }

    private java.sql.Connection getHeighAvailLoadBalanceConnection(String gclusterId, Properties props, String originalUrl) throws SQLException {
        Connection newConn = null;
        do {
            String ip;
            if ((ip = GcGBaseLoadBalance.getNiceIp(gclusterId)) == null) {
                throw this.createAllHostGoneAwayExecption(gclusterId);
            }
            props.setProperty("HOST", ip);
            try {
                newConn = ConnectionImpl.getInstance(GcGBaseLoadBalanceConnection.host(props), GcGBaseLoadBalanceConnection.port(props), props, GcGBaseLoadBalanceConnection.database(props), originalUrl);
            }
            catch (SQLException sqlEx) {
                String sqlStatus = sqlEx.getSQLState();
                int errorCode = sqlEx.getErrorCode();
                if (GBaseErrForCluster.isNotRetry(errorCode) || "28000".equals(sqlStatus)) {
                    throw sqlEx;
                }
                GcGBaseLoadBalance.setBrokenIp(ip, gclusterId);
                if (newConn == null || newConn.isClosed()) continue;
                newConn.close();
                newConn = null;
            }
            catch (Exception ex) {
                SQLException sqlEx = SQLError.createSQLException(Messages.getString("NonRegisteringDriver.17") + ex.toString() + Messages.getString("NonRegisteringDriver.18"), "08001", null);
                sqlEx.initCause(ex);
                throw sqlEx;
            }
        } while (newConn == null);
        return newConn;
    }

    public static String host(Properties props) {
        return props.getProperty("HOST");
    }

    public static int port(Properties props) {
        return Integer.parseInt(props.getProperty("PORT", "5258"));
    }

    public static String database(Properties props) {
        return props.getProperty("DBNAME");
    }
}

