/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzAV;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.zz0E;
import com.aspose.words.zz9V;
import com.aspose.words.zzZIP;
import com.aspose.words.zzZRT;
import com.aspose.words.zzZSX;

public abstract class Node
implements Cloneable {
    private Node zzYW6;
    private Node zzYW5;
    private Node zzYW4;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzZ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYW6 == null) {
            return null;
        }
        if (this.zzYW6.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYW6;
    }

    CompositeNode zzZtx() {
        return zzZIP.zzZa(this.getParentNode()) ? this.getParentNode().zzZtx() : this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYW6 == null) {
            return null;
        }
        return this.zzYW6.getDocument();
    }

    Document zzZRX() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    Document zzZtw() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz12();
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            return this.zzZtq();
        }
        return null;
    }

    Node zzZtv() {
        Node node = zzZIP.zzZ8(this.getPreviousSibling());
        if (node == null && zzZIP.zzZa(this.getParentNode())) {
            node = this.getParentNode().zzZtv();
        }
        return node;
    }

    Node zzZtu() {
        Node node = zzZIP.zzZ9(this.getNextSibling());
        if (node == null && zzZIP.zzZa(this.getParentNode())) {
            node = this.getParentNode().zzZtu();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            return this.zzZtr();
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    boolean zzZtt() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    boolean zzZts() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzZIP.zzZj(node)) continue;
            return false;
        }
        return true;
    }

    Node zzZtr() {
        return this.zzYW5;
    }

    void zzZM(Node node) {
        this.zzYW5 = node;
    }

    Node zzZtq() {
        return this.zzYW4;
    }

    void zzZL(Node node) {
        this.zzYW4 = node;
    }

    int zzZtp() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzZIP.zzZf(this)) {
            return 3;
        }
        if (zzZIP.zzZe(this)) {
            return 4;
        }
        if (zzZIP.zzZd(this)) {
            return 5;
        }
        if (zzZIP.zzZc(this)) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) throws Exception {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZRT zzZRT2) throws Exception {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYW6 != null) {
            node.zzYW6 = this.getDocument().zzZZD();
        }
        node.zzYW5 = null;
        node.zzYW4 = null;
        if (zzZRT2 != null) {
            zzZRT2.zzV(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    void zzZK(Node node) {
        this.zzYW6 = node != null ? node : this.getDocument().zzZZD();
    }

    void zzZ(DocumentBase documentBase) {
        this.zzYW6 = documentBase != null ? documentBase.zzZZD() : null;
    }

    boolean zzZJ(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node;
        Node node2 = node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node = this.getPreviousSibling();
        while (node != null) {
            Node node2;
            Node node3 = node2 = node.isComposite() ? ((CompositeNode)node).getLastChild() : null;
            if (node2 == null) break;
            node = node2;
        }
        if (node == null) {
            node = this.getParentNode();
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    Node zzDJ(int n) {
        Node node;
        for (node = this.getNextSibling(); null != node && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    Node zzDI(int n) {
        Node node;
        for (node = this.getPreviousSibling(); null != node && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    Node zzTT(boolean bl) {
        return bl ? this.getNextSibling() : this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zzZSX zzZSX2 = zz0E.zzId(saveFormat);
        return zzZSX2.zz0(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZSX zzZSX2 = zz0E.zzX(saveOptions);
        return zzZSX2.zz0(this);
    }

    Node zzDH(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); null != compositeNode; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzZIP.zzZg(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    zz9V zzZto() {
        Node node = this.getPreviousSibling();
        return node != null ? zz9V.zzA(node) : zz9V.zzB(this.getParentNode());
    }

    zz9V zzZtn() {
        Node node = this.getNextSibling();
        return node != null ? zz9V.zzB(node) : zz9V.zzA(this.getParentNode());
    }

    boolean zzZI(Node node) {
        return Node.zzP(this, node);
    }

    boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    static boolean zzP(Node node, Node node2) {
        zzAV zzAV2;
        if (node == null || node2 == null) {
            return false;
        }
        zzAV zzAV3 = Node.zzZH(node);
        Node node3 = (Node)Node.zzZ(zzAV3, zzAV2 = Node.zzZH(node2));
        if (node3 == null) {
            return false;
        }
        if (zzAV3.getCount() == 0 || zzAV2.getCount() == 0) {
            boolean bl = zzAV2.getCount() > 0;
            return bl;
        }
        Object e = zzAV3.peek();
        Object e2 = zzAV2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzAV zzZH(Node node) {
        zzAV zzAV2 = new zzAV();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzAV2.push(node2);
        }
        return zzAV2;
    }

    private static Object zzZ(zzAV zzAV2, zzAV zzAV3) {
        Object var2_2 = null;
        while (zzAV2.peek() == zzAV3.peek()) {
            var2_2 = zzAV2.pop();
            zzAV3.pop();
            if (zzAV2.getCount() != 0 && zzAV3.getCount() != 0) continue;
            break;
        }
        return var2_2;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

