/*
 * Decompiled with CFR 0.152.
 */
package cn.com.jit.qrcode;

import cn.com.jit.exception.JitGatewayException;
import cn.com.jit.qrcode.JitQRCodeConfiguration;
import cn.com.jit.qrcode.request.AuthQRCodeRequest;
import cn.com.jit.qrcode.request.PollQRCodeRequest;
import cn.com.jit.qrcode.response.AuthQRCodeResponse;
import cn.com.jit.qrcode.response.GenerateQRCodeResponse;
import cn.com.jit.qrcode.response.PollQRCodeResponse;
import cn.com.jit.util.HTTPSSecureProtocolSocketFactory;
import cn.com.jit.util.PropertiesUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JitGatewayQRCodeClient {
    private JitQRCodeConfiguration jitQRCodeConfiguration;

    public JitGatewayQRCodeClient(JitQRCodeConfiguration jitQRCodeConfiguration) throws JitGatewayException {
        if (!jitQRCodeConfiguration.validate()) {
            throw new JitGatewayException("\u6570\u636e\u9519\u8bef");
        }
        this.jitQRCodeConfiguration = jitQRCodeConfiguration;
    }

    public JitGatewayQRCodeClient(String filePath) throws JitGatewayException {
        Map<String, Object> map = PropertiesUtil.read(filePath);
        JitQRCodeConfiguration jqc = new JitQRCodeConfiguration(map);
        if (!jqc.validate()) {
            throw new JitGatewayException("\u6570\u636e\u9519\u8bef");
        }
        this.jitQRCodeConfiguration = jqc;
    }

    public GenerateQRCodeResponse generate() throws JitGatewayException {
        GenerateQRCodeResponse response;
        block9: {
            response = new GenerateQRCodeResponse();
            HttpClient httpClient = new HttpClient();
            PostMethod postMethod = new PostMethod(this.jitQRCodeConfiguration.getGwUrl() + "/jit_qrcode_generate");
            postMethod.setRequestHeader("appFlag", this.jitQRCodeConfiguration.getAppId());
            postMethod.setRequestHeader("Connection", "close");
            postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
            HashMap<String, String> propsMap = new HashMap<String, String>();
            propsMap.put("Service_Type", "qrcode_generate");
            Set keySet = propsMap.keySet();
            NameValuePair[] postData = new NameValuePair[keySet.size()];
            int index = 0;
            for (Object key : keySet.toArray()) {
                postData[index++] = new NameValuePair(key.toString(), propsMap.get(key).toString());
            }
            postMethod.addParameters(postData);
            try {
                int statusCode;
                URL url = new URL(this.jitQRCodeConfiguration.getGwUrl());
                if (this.jitQRCodeConfiguration.getGwUrl() != null && "https".equals(url.getProtocol())) {
                    Protocol https = new Protocol("https", (ProtocolSocketFactory)new HTTPSSecureProtocolSocketFactory(), url.getPort() == -1 ? 443 : url.getPort());
                    Protocol.registerProtocol((String)"https", (Protocol)https);
                }
                if ((statusCode = httpClient.executeMethod((HttpMethod)postMethod)) == 200) {
                    response.setImage(new String(Base64.encodeBase64((byte[])postMethod.getResponseBody())));
                    response.setCode(httpClient.getState().getCookies()[0].getValue());
                    System.out.println("\u751f\u6210\u4e8c\u7ef4\u7801\u6210\u529f");
                    break block9;
                }
                System.out.println("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25,\u7f51\u5173\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + statusCode);
                throw new JitGatewayException("Connection failed (" + statusCode + ")");
            }
            catch (JitGatewayException e) {
                throw e;
            }
            catch (Exception e1) {
                throw new JitGatewayException(e1);
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return response;
    }

    public PollQRCodeResponse poll(PollQRCodeRequest pollQRCodeRequest) throws JitGatewayException {
        PollQRCodeResponse response;
        block11: {
            if (!pollQRCodeRequest.validate()) {
                throw new JitGatewayException("\u6570\u636e\u9519\u8bef");
            }
            response = new PollQRCodeResponse();
            HttpClient httpClient = new HttpClient();
            PostMethod postMethod = new PostMethod(this.jitQRCodeConfiguration.getGwUrl() + "/jit_qrcode_poll?jit_qrcode=" + pollQRCodeRequest.getCode());
            postMethod.setRequestHeader("Connection", "close");
            try {
                int statusCode;
                URL url = new URL(this.jitQRCodeConfiguration.getGwUrl());
                if (this.jitQRCodeConfiguration.getGwUrl() != null && "https".equals(url.getProtocol())) {
                    Protocol https = new Protocol("https", (ProtocolSocketFactory)new HTTPSSecureProtocolSocketFactory(), url.getPort() == -1 ? 443 : url.getPort());
                    Protocol.registerProtocol((String)"https", (Protocol)https);
                }
                if ((statusCode = httpClient.executeMethod((HttpMethod)postMethod)) == 200) {
                    InputStream ins = postMethod.getResponseBodyAsStream();
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(ins);
                    String error = document.getElementsByTagName("result").item(0).getAttributes().getNamedItem("errorcode").getNodeValue();
                    if ("0".equals(error)) {
                        String state = document.getElementsByTagName("qrcode_state").item(0).getTextContent();
                        response.setState(state);
                        System.out.println("\u67e5\u8be2\u4e8c\u7ef4\u7801\u72b6\u6001\u6210\u529f\uff1a" + state);
                        if ("3".equals(state)) {
                            String token = document.getElementsByTagName("jit_token").item(0).getTextContent();
                            response.setToken(token);
                        }
                        break block11;
                    }
                    String errorMsg = document.getElementsByTagName("errormsg").item(0).getTextContent();
                    System.out.println("\u67e5\u8be2\u4e8c\u7ef4\u7801\u72b6\u6001\u5931\u8d25\uff1a" + errorMsg);
                    throw new JitGatewayException(errorMsg);
                }
                System.out.println("\u67e5\u8be2\u4e8c\u7ef4\u7801\u72b6\u6001\u5931\u8d25\uff0c\u7f51\u5173\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + statusCode);
                throw new JitGatewayException("Connection failed (" + statusCode + ")");
            }
            catch (JitGatewayException e) {
                throw e;
            }
            catch (Exception e1) {
                System.out.println("\u67e5\u8be2\u4e8c\u7ef4\u7801\u72b6\u6001\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f" + e1.getMessage());
                throw new JitGatewayException(e1);
            }
            finally {
                postMethod.releaseConnection();
            }
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthQRCodeResponse auth(AuthQRCodeRequest authQRCodeRequest) throws JitGatewayException {
        if (!authQRCodeRequest.validate()) {
            throw new JitGatewayException("\u6570\u636e\u9519\u8bef");
        }
        AuthQRCodeResponse response = new AuthQRCodeResponse();
        Object errCode = null;
        Object errDesc = null;
        String authURL = this.jitQRCodeConfiguration.getGwUrl() + "/MessageService";
        String appId = this.jitQRCodeConfiguration.getAppId();
        System.out.println("\u5e94\u7528\u6807\u8bc6\u53ca\u7f51\u5173\u7684\u8ba4\u8bc1\u5730\u5740\u8bfb\u53d6\u6210\u529f\uff01\n\u5e94\u7528\u6807\u8bc6\uff1a" + appId + "\n\u8ba4\u8bc1\u5730\u5740\uff1a" + authURL + "\n");
        System.out.println("\u7ec4\u88c5\u8ba4\u8bc1\u8bf7\u6c42\u62a5\u6587\u5f00\u59cb");
        String clientip = authQRCodeRequest.getClientIp();
        String token = authQRCodeRequest.getToken();
        String code = authQRCodeRequest.getCode();
        String sendMsg = "<?xml\u00a0version=\"1.0\"\u00a0encoding=\"UTF-8\"?><message><head><version>1.0</version><serviceType>AuthenService</serviceType></head><body><clientInfo><clientIP>" + (clientip != null ? clientip : "") + "</clientIP></clientInfo><appId>" + appId + "</appId>" + "<authen><authCredential authMode=\"qrcode\"><token>" + token + "</token>" + "<QRCode>" + code + "</QRCode></authCredential></authen>" + "<accessControl>false</accessControl><attributes\u00a0attributeType=\"all\"/></body></message>";
        System.out.println("\u7ec4\u88c5\u8ba4\u8bc1\u8bf7\u6c42\u62a5\u6587\u7ed3\u675f");
        try {
            System.out.println("\u5411\u7f51\u5173\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42\u5f00\u59cb");
            HttpClient httpClient = new HttpClient();
            PostMethod postMethod = new PostMethod(authURL);
            postMethod.setRequestHeader("Connection", "close");
            postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
            postMethod.setRequestBody(sendMsg);
            URL url = new URL(this.jitQRCodeConfiguration.getGwUrl());
            if (this.jitQRCodeConfiguration.getGwUrl() != null && "https".equals(url.getProtocol())) {
                Protocol https = new Protocol("https", (ProtocolSocketFactory)new HTTPSSecureProtocolSocketFactory(), url.getPort() == -1 ? 443 : url.getPort());
                Protocol.registerProtocol((String)"https", (Protocol)https);
            }
            int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            System.out.println("\u5411\u7f51\u5173\u53d1\u9001\u8ba4\u8bc1\u8bf7\u6c42\u7ed3\u675f");
            if (statusCode != 200) {
                System.out.println("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u72b6\u6001\u5931\u8d25\uff0c\u7f51\u5173\u8fd4\u56de\u72b6\u6001\u7801\uff1a" + statusCode);
                throw new JitGatewayException("Connection failed (" + statusCode + ")");
            }
            System.out.println("\u8bfb\u53d6\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u5f00\u59cb");
            InputStream ins = postMethod.getResponseBodyAsStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(ins);
            String error = document.getElementsByTagName("messageState").item(0).getTextContent();
            if (!"false".equals(error)) {
                String errorCode = document.getElementsByTagName("messageCode").item(0).getTextContent();
                String errorDesc = document.getElementsByTagName("messageDesc").item(0).getTextContent();
                System.out.println("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u72b6\u6001\u5931\u8d25\uff1a" + errorCode + errorDesc);
                throw new JitGatewayException(errorCode, errorDesc);
            }
            NodeList attrs = document.getElementsByTagName("attr");
            int i = 0;
            while (true) {
                if (i >= attrs.getLength()) {
                    System.out.println("\u8bfb\u53d6\u7f51\u5173\u8fd4\u56de\u7684\u8ba4\u8bc1\u54cd\u5e94\u62a5\u6587\u7ed3\u675f");
                    return response;
                }
                Node node = attrs.item(i);
                String key = node.getAttributes().getNamedItem("name").getNodeValue();
                String nameSpace = node.getAttributes().getNamedItem("namespace").getNodeValue();
                String value = node.getTextContent();
                if ("http://www.jit.com.cn/gw/custom/attribute".equals(nameSpace)) {
                    response.getCustomAttributeNodeMap().put(key, value);
                } else if ("http://www.jit.com.cn/ums/ns/user".equals(nameSpace)) {
                    response.getUmsAttributeNodeMap().put(key, value);
                } else if ("http://www.jit.com.cn/pmi/pms".equals(nameSpace)) {
                    response.getPmsAttributeNodeMap().put(key, value);
                } else {
                    response.getCertAttributeNodeMap().put(key, value);
                }
                ++i;
            }
        }
        catch (JitGatewayException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw new JitGatewayException(e);
        }
    }

    public JitQRCodeConfiguration getJitQRCodeConfiguration() {
        return this.jitQRCodeConfiguration;
    }

    public void setJitQRCodeConfiguration(JitQRCodeConfiguration jitQRCodeConfiguration) {
        this.jitQRCodeConfiguration = jitQRCodeConfiguration;
    }
}

