/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz8W;
import asposewobfuscated.zzFD;
import asposewobfuscated.zzWQ;
import com.aspose.words.Cell;
import com.aspose.words.Comment;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Field;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.HeaderFooter;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.ListLabel;
import com.aspose.words.ListLevel;
import com.aspose.words.Node;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.Run;
import com.aspose.words.RunCollection;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.Style;
import com.aspose.words.TabStop;
import com.aspose.words.Table;
import com.aspose.words.zz0M;
import com.aspose.words.zz0R;
import com.aspose.words.zz41;
import com.aspose.words.zz6;
import com.aspose.words.zz7G;
import com.aspose.words.zzZ4B;
import com.aspose.words.zzZB5;
import com.aspose.words.zzZIP;
import com.aspose.words.zzZNP;
import com.aspose.words.zzZQ7;
import com.aspose.words.zzZQW;
import com.aspose.words.zzZRD;
import com.aspose.words.zzZRK;
import com.aspose.words.zzZRT;

public class Paragraph
extends CompositeNode<Node>
implements zzZQW,
zzZRD,
zzZRK {
    private zzZB5 zzZi9;
    private zzZ4B zzYJl;
    private ParagraphFormat zzYJk;
    private ListFormat zzZ6h;
    private ListFormat zzYJj;
    private ListLabel zzYJi;
    private RunCollection zzYJh;

    public Paragraph(DocumentBase doc) {
        this(doc, new zzZB5(), new zzZ4B());
    }

    Paragraph(DocumentBase doc, zzZB5 paraPr, zzZ4B runPr) {
        super(doc);
        this.zzZi9 = paraPr;
        this.zzYJl = runPr;
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    public Story getParentStory() {
        return (Story)this.getAncestor(Story.class);
    }

    public Section getParentSection() {
        return (Section)this.getAncestor(2);
    }

    public boolean isInCell() {
        return this.zzZtx() instanceof Cell;
    }

    boolean zzZk6() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode == null) {
            return false;
        }
        if (zzZIP.zzZa(compositeNode)) {
            return this.isInCell() && this.zzZJ(this.zzZtx().getFirstChild());
        }
        return this.isInCell() && this == compositeNode.getFirstChild();
    }

    public boolean isEndOfCell() {
        CompositeNode compositeNode = this.zzZtx();
        return compositeNode instanceof Cell && compositeNode.zznT() == this;
    }

    boolean zzZk5() {
        return this.isEndOfCell() && this.zzZQC().isLastCell();
    }

    Cell zzZQC() {
        return (Cell)this.zzZtx();
    }

    Row getParentRow() {
        if (this.zzZQC() == null) {
            return null;
        }
        return this.zzZQC().getParentRow();
    }

    Table getParentTable() {
        if (this.getParentRow() == null) {
            return null;
        }
        return this.getParentRow().getParentTable();
    }

    boolean zzZk4() {
        return this.zzZtx() instanceof Shape;
    }

    public boolean isEndOfSection() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1 && this == story.zznT();
    }

    public boolean isEndOfHeaderFooter() {
        Story story = this.getParentStory();
        return story instanceof HeaderFooter && story.zznT() == this;
    }

    public boolean isEndOfDocument() {
        if (!this.isEndOfSection()) {
            return false;
        }
        for (Node node = this.getDocument().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (!(node instanceof Section)) continue;
            return node == this.getParentSection();
        }
        return true;
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzYJk == null) {
            this.zzYJk = new ParagraphFormat(this, this.getDocument().getStyles());
        }
        return this.zzYJk;
    }

    public ListFormat getListFormat() {
        if (this.zzZ6h == null) {
            this.zzZ6h = new ListFormat(this, this, this.getDocument().getLists());
        }
        return this.zzZ6h;
    }

    ListFormat zzZk3() throws Exception {
        if (this.zzYJj == null) {
            Paragraph paragraph = (Paragraph)this.deepClone(false);
            this.zzYJj = new ListFormat(paragraph, paragraph, this.getDocument().getLists());
        }
        return this.zzYJj;
    }

    public ListLabel getListLabel() throws Exception {
        if (this.zzYJi == null) {
            this.zzYJi = new ListLabel(this);
        }
        return this.zzYJi;
    }

    public RunCollection getRuns() {
        if (this.zzYJh == null) {
            this.zzYJh = new RunCollection(this);
        }
        return this.zzYJh;
    }

    public Font getParagraphBreakFont() {
        return new Font(this, this.getDocument());
    }

    public boolean isInsertRevision() {
        return this.zzYJl.zzYX1();
    }

    public boolean isDeleteRevision() {
        return this.zzYJl.zzYX2();
    }

    Style zzZk2() {
        return this.getDocument().getStyles().zzXs(this.zzZi9.zzZLD(), 0);
    }

    Style zzZk1() {
        return this.getDocument().getStyles().zzXs(this.zzYJl.zzZLD(), 10);
    }

    zzZB5 zzZK7() {
        return this.zzZi9;
    }

    void zzS(zzZB5 zzZB52) {
        this.zzZi9 = zzZB52;
    }

    void zzY(String[] stringArray, zzZNP zzZNP2) throws Exception {
        this.getListLabel().zzZ(stringArray, zzZNP2.zzZzB());
    }

    void zzZo(Paragraph paragraph) throws Exception {
        this.getListLabel().zzZ(paragraph.getListLabel().zzZzX(), paragraph.getListLabel().zzZzY().zzZzB());
    }

    void zzZn(Paragraph paragraph) throws Exception {
        if (paragraph.getListLabel().zzZzX() != null && paragraph.getListLabel().zzZzY() != null) {
            this.zzZo(paragraph);
        }
    }

    void zzZk0() throws Exception {
        if (this.zzYJi != null) {
            this.getListLabel().zzZ(null, null);
        }
    }

    zzZ4B zzZjZ() {
        return this.zzYJl;
    }

    void zzN(zzZ4B zzZ4B2) {
        this.zzYJl = zzZ4B2;
    }

    @Override
    Node zzZ(boolean bl, zzZRT zzZRT2) throws Exception {
        zzZ4B zzZ4B2;
        zzZB5 zzZB52;
        Paragraph paragraph = (Paragraph)super.zzZ(bl, zzZRT2);
        paragraph.zzZi9 = zzZB52 = (zzZB5)this.zzZi9.zzuY();
        paragraph.zzYJl = zzZ4B2 = (zzZ4B)this.zzYJl.zzuY();
        paragraph.zzYJk = null;
        paragraph.zzZ6h = null;
        paragraph.zzYJi = null;
        paragraph.zzYJh = null;
        return paragraph;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphStart(this);
    }

    @Override
    int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitParagraphEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    zzZB5 zzHP(int n) throws Exception {
        zzZB5 zzZB52 = new zzZB5();
        this.zzZ(zzZB52, n);
        if (this.zzZk4()) {
            zzZB52.zzZke();
        }
        return zzZB52;
    }

    void zzZ(zzZB5 zzZB52, int n) throws Exception {
        Cloneable cloneable;
        boolean bl;
        boolean bl2 = bl = (n & 0x40) != 0;
        if ((n & 1) != 0) {
            this.getDocument().getStyles().zzZ3B().zzZ((zz6)zzZB52, bl);
        }
        if ((n & 4) != 0 && (cloneable = (Table)this.getAncestor(5)) != null) {
            ((Table)cloneable).getStyle().zzZ(zzZB52, n);
        }
        cloneable = this.zzZi9.zzAF(n);
        if ((n & 0x10) != 0 && this.zzZi9.zzsx()) {
            zzZB52.zzZ((zz0M)this.zzZi9.zzYWY().deepCloneComplexAttr());
        }
        Style style = this.getDocument().getStyles().zzXs(((zzZB5)cloneable).zzZLD(), 0);
        style.zzZ(zzZB52, n);
        if (zzZB52.getListId() != ((zzZB5)cloneable).getListId() || zzZB52.zzZCo() != ((zzZB5)cloneable).zzZCo()) {
            Cloneable cloneable2 = cloneable;
            if (!((zzFD)cloneable).contains(1110) && zzZB52.contains(1110)) {
                cloneable2 = (zzZB5)((zz6)cloneable).zzuY();
                ((zz6)cloneable2).zzX(1110, zzZB52.get(1110));
            }
            this.getDocument().getLists().zzY((zzZB5)cloneable2, zzZB52);
        }
        if ((n & 8) != 0) {
            this.getDocument().zzZZC().zzZ(this.zzZi9, zzZB52);
        }
        ((zz6)cloneable).zzZ(zzZB52);
        ((zzZB5)cloneable).zzQ(zzZB52);
        if (((zzZB5)cloneable).zzZkK()) {
            if (!((zzFD)cloneable).contains(1170)) {
                zzZB52.zzF8(0);
            }
            if (!((zzFD)cloneable).contains(1160)) {
                zzZB52.zzF7(0);
            }
        }
        if ((n & 2) != 0) {
            zzZB52.zzZkd();
        }
    }

    zzZ4B zzAB(int n) throws Exception {
        zzZ4B zzZ4B2 = new zzZ4B();
        this.zzX(zzZ4B2, n);
        return zzZ4B2;
    }

    void zzX(zzZ4B zzZ4B2, int n) throws Exception {
        zzZQ7.zzZ(this.getDocument(), zzZQ7.zzY(this, n), this.zzZk1(), this.zzZjU() ? this.getParentTable().getStyle() : null, this.zzYJl.zzyk(n), zzZ4B2, n);
    }

    boolean zzZjY() {
        CompositeNode compositeNode = this.zzZtx();
        return compositeNode instanceof Comment && this == compositeNode.zznT();
    }

    boolean zzZjX() {
        CompositeNode compositeNode = this.zzZtx();
        return compositeNode instanceof Footnote && this == compositeNode.zznT();
    }

    boolean zzZjW() {
        CompositeNode compositeNode = this.zzZtx();
        return compositeNode instanceof zz0R && this == compositeNode.zznT();
    }

    boolean zzZjV() {
        CompositeNode compositeNode = this.zzZtx();
        return compositeNode instanceof Shape && compositeNode.zznT() == this;
    }

    void zzZ(double[] dArray, double[] dArray2, boolean[] blArray) throws Exception {
        dArray[0] = 2.147483647E9;
        dArray2[0] = 0.0;
        blArray[0] = false;
        for (Node node = this.zznU(); node != null; node = node.zzZtu()) {
            if (!(node instanceof Inline)) continue;
            Paragraph.zzZ((Inline)node, dArray, dArray2, blArray);
        }
        if (dArray2[0] == 0.0) {
            Paragraph.zzZ(this, dArray, dArray2, blArray);
        }
    }

    private static void zzZ(zzZRD zzZRD2, double[] dArray, double[] dArray2, boolean[] blArray) throws Exception {
        Object object = zzZRD2.getDirectRunAttr(190);
        double d = zzWQ.zzZw((Integer)(object != null ? object : zzZRD2.fetchInheritedRunAttr(190)));
        dArray[0] = Math.min(d, dArray[0]);
        dArray2[0] = Math.max(d, dArray2[0]);
        if (!blArray[0]) {
            boolean bl = blArray[0] = object != null;
            if (!blArray[0]) {
                Object object2 = zzZRD2.getDirectRunAttr(50);
                blArray[0] = object2 != null && (Integer)object2 != 10;
            }
        }
    }

    @Override
    String zznS() {
        if (this.isEndOfCell()) {
            return ControlChar.CELL;
        }
        if (this.isEndOfSection()) {
            return ControlChar.SECTION_BREAK;
        }
        return ControlChar.PARAGRAPH_BREAK;
    }

    @Override
    boolean zzP(Node node) {
        return zzZIP.zzZc(node);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getDirectParaKey(int index) {
        return this.zzZi9.zzV2(index);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzZi9.zzT3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getDirectParaAttrsCount() {
        return this.zzZi9.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        Object object;
        ListLevel listLevel = this.getDocument().getLists().zzW(this.zzZK7());
        if (listLevel != null) {
            object = listLevel.zzZK7().zzT3(key);
            if (object != null) {
                return object;
            }
        } else if (this.zzZi9.zzZkK() && (key == 1160 || key == 1170)) {
            return 0;
        }
        if ((object = this.zzZk2().zzwZ(key)) != null) {
            return object;
        }
        return this.zzZjU() ? this.getParentTable().getStyle().fetchParaAttr(key) : this.getDocument().getStyles().zzZ3B().fetchParaAttr(key);
    }

    private boolean zzZjU() {
        return this.isInCell() && this.getParentRow() != null && this.getParentTable() != null && this.getDocument().getStyles().zzZK(this.getParentTable().zzZLD(), false) != null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        Object object = this.getDirectParaAttr(key);
        return object != null ? object : this.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        this.zzZi9.zzX(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzZi9.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzZi9.zzv0();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunKey(int index) {
        return this.zzYJl.zzV2(index);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key) {
        return this.zzYJl.zzT3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public int getDirectRunAttrsCount() {
        return this.zzYJl.getCount();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int key) throws Exception {
        Object object = this.zzZk1().zzZM(key, false);
        if (object != null) {
            return object;
        }
        return this.zzZk2().zzZM(key, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int key, Object value) {
        this.zzYJl.zzX(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzYJl.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzYJl.zzv0();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz7G getInsertRevision() {
        return this.zzZjZ().getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zz7G value) {
        this.zzZjZ().setInsertRevision(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zz7G getDeleteRevision() {
        return this.zzZjZ().getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zz7G value) {
        this.zzZjZ().setDeleteRevision(value);
    }

    boolean zzZjT() throws Exception {
        double d;
        Node node = this.zzZtu();
        if (!(node instanceof Paragraph)) {
            return false;
        }
        Paragraph paragraph = (Paragraph)node;
        ParagraphFormat paragraphFormat = this.getParagraphFormat();
        ParagraphFormat paragraphFormat2 = paragraph.getParagraphFormat();
        if (paragraphFormat2.getPageBreakBefore()) {
            return false;
        }
        double d2 = paragraphFormat.getLeftIndent() + Math.min(paragraphFormat.getFirstLineIndent(), 0.0);
        if (d2 != (d = paragraphFormat2.getLeftIndent() + Math.min(paragraphFormat2.getFirstLineIndent(), 0.0))) {
            return false;
        }
        if (paragraphFormat.getRightIndent() != paragraphFormat2.getRightIndent()) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(1).zzZ(paragraphFormat2.getBorders().getByBorderType(1))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(2).zzZ(paragraphFormat2.getBorders().getByBorderType(2))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(3).zzZ(paragraphFormat2.getBorders().getByBorderType(3))) {
            return false;
        }
        if (!paragraphFormat.getBorders().getByBorderType(0).zzZ(paragraphFormat2.getBorders().getByBorderType(0))) {
            return false;
        }
        return this.zzZm(paragraph);
    }

    boolean zzZm(Paragraph paragraph) {
        return this.zzZi9.zzR(paragraph.zzZK7());
    }

    Run zzZjS() {
        return (Run)this.getChild(21, 0, false);
    }

    Run zzZjR() {
        Run run = null;
        for (Node node = this.zznU(); node != null; node = node.zzZtu()) {
            if (node.getNodeType() != 21) continue;
            run = (Run)node;
        }
        return run;
    }

    boolean zzZLL() {
        Story story = this.getParentStory();
        return story != null && story.getStoryType() == 1;
    }

    public boolean isListItem() {
        return (Integer)this.fetchParaAttr(1120) != 0;
    }

    boolean zzZjQ() {
        return ((zzZB5)this.zzZK7().zzYWY().zzZLd()).getListId() == 0;
    }

    public TabStop[] getEffectiveTabStops() throws Exception {
        zzZB5 zzZB52 = this.zzHP(0);
        int n = zzZB52.contains(1140) ? zzZB52.getTabStops().getCount() : 0;
        TabStop[] tabStopArray = new TabStop[n];
        for (int i = 0; i < n; ++i) {
            tabStopArray[i] = zzZB52.getTabStops().get(i).zzZ2s();
        }
        return tabStopArray;
    }

    public int joinRunsWithSameFormatting() throws Exception {
        return this.zzQ(new StringBuilder());
    }

    boolean zzZjP() throws Exception {
        return this.isListItem() && this.getListLabel().zzV2();
    }

    boolean hasRevisions() {
        return this.zzZjZ().hasRevisions() || this.zzZK7().hasRevisions() || this.zzZK7().zzZkI();
    }

    boolean zzZjO() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!zzZIP.zzZi(node)) continue;
            return true;
        }
        return false;
    }

    boolean zzZjN() {
        for (Node node : this.getChildNodes()) {
            if (zzZIP.zzZh(node)) continue;
            return false;
        }
        return true;
    }

    int zzQ(StringBuilder stringBuilder) throws Exception {
        int n = 0;
        Run run = null;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() == 21) {
                Run run2 = (Run)node;
                if (run != null) {
                    zzZ4B zzZ4B2 = new zzZ4B();
                    zzZ4B2.zzZ((zz6)zzZ4B2, true);
                    run.zzGx(0).zzZ(zzZ4B2);
                    zzZ4B zzZ4B3 = new zzZ4B();
                    zzZ4B3.zzZ((zz6)zzZ4B3, true);
                    run2.zzGx(0).zzZ(zzZ4B3);
                    if (zzZ4B2.zzY((zz6)zzZ4B3, Run.zzYvI)) {
                        if (stringBuilder.length() == 0) {
                            zz8W.zzX(stringBuilder, run.getText());
                        }
                        zz8W.zzX(stringBuilder, run2.getText());
                        ++n;
                        this.removeChild(run);
                    } else {
                        Paragraph.zzZ(run, stringBuilder);
                    }
                }
                run = run2;
                continue;
            }
            Paragraph.zzZ(run, stringBuilder);
            run = null;
        }
        Paragraph.zzZ(run, stringBuilder);
        return n;
    }

    private static void zzZ(Run run, StringBuilder stringBuilder) throws Exception {
        if (run != null && stringBuilder.length() != 0) {
            run.setText(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    public Field appendField(int fieldType, boolean updateField) throws Exception {
        return zz41.zzZ(fieldType, updateField, this.zzZQf(), null, (CompositeNode)this, null, true);
    }

    public Field appendField(String fieldCode) throws Exception {
        return zz41.zzZ(fieldCode, this.zzZQf(), null, (CompositeNode)this, null, true);
    }

    public Field appendField(String fieldCode, String fieldValue) throws Exception {
        return zz41.zzZ(fieldCode, fieldValue, this.zzZQf(), null, (CompositeNode)this, null, true);
    }

    public Field insertField(int fieldType, boolean updateField, Node refNode, boolean isAfter) throws Exception {
        return zz41.zzZ(fieldType, updateField, this.zzZQf(), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, Node refNode, boolean isAfter) throws Exception {
        return zz41.zzZ(fieldCode, this.zzZQf(), null, (CompositeNode)this, refNode, isAfter);
    }

    public Field insertField(String fieldCode, String fieldValue, Node refNode, boolean isAfter) throws Exception {
        return zz41.zzZ(fieldCode, fieldValue, this.zzZQf(), null, (CompositeNode)this, refNode, isAfter);
    }

    private zzZ4B zzZQf() {
        return this.getRuns().getCount() > 0 ? this.getRuns().get(this.getRuns().getCount() - 1).zzZQf() : this.zzZjZ();
    }
}

