/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.filters;

import com.tongweb.container.filters.FilterBase;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.http.Parameters;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class FailedRequestFilter
extends FilterBase {
    private final Log log = LogFactory.getLog(FailedRequestFilter.class);

    @Override
    protected Log getLogger() {
        return this.log;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.isGoodRequest(request)) {
            Parameters.FailReason reason = (Parameters.FailReason)((Object)request.getAttribute("com.tongweb.container.parameter_parse_failed_reason"));
            ((HttpServletResponse)response).sendError(switch (reason) {
                case Parameters.FailReason.IO_ERROR -> 500;
                case Parameters.FailReason.POST_TOO_LARGE -> 413;
                default -> 400;
            });
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean isGoodRequest(ServletRequest request) {
        request.getParameter("none");
        return request.getAttribute("com.tongweb.container.parameter_parse_failed") == null;
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }
}

