/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.ws.servlet;

import com.tongweb.springboot.autoconfigure.web.servlet.LiteTongWeb;
import com.tongweb.springboot.ws.servlet.TongWebDelegateHandlerRegistry;
import com.tongweb.springboot.ws.servlet.TongWebWebSocketServletWebServerCustomizer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketConfiguration;
import org.springframework.web.socket.config.annotation.WebSocketConfigurationSupport;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@ConditionalOnClass(name={"org.springframework.web.socket.config.annotation.DelegatingWebSocketConfiguration"})
@AutoConfigureBefore(value={LiteTongWeb.class})
@AutoConfigureOrder(value=-2147483648)
public class TongWebWsAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(TongWebWsAutoConfiguration.class);

    @Bean
    public TongWebWebSocketServletWebServerCustomizer tongWebContainerCustomizer() {
        return new TongWebWebSocketServletWebServerCustomizer();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            DelegatingWebSocketConfiguration bean = (DelegatingWebSocketConfiguration)applicationContext.getBean(DelegatingWebSocketConfiguration.class);
            Field handlerRegistry = WebSocketConfigurationSupport.class.getDeclaredField("handlerRegistry");
            handlerRegistry.setAccessible(true);
            TongWebDelegateHandlerRegistry value = new TongWebDelegateHandlerRegistry();
            handlerRegistry.set(bean, (Object)value);
            Method registerWebSocketHandlers = WebSocketConfigurationSupport.class.getDeclaredMethod("registerWebSocketHandlers", WebSocketHandlerRegistry.class);
            registerWebSocketHandlers.setAccessible(true);
            registerWebSocketHandlers.invoke((Object)bean, new Object[]{value});
        }
        catch (Throwable t) {
            if (t instanceof BeansException) {
                logger.warn((Object)"Please ensure that @EnableWebSocket is enabled");
                logger.error((Object)t);
                return;
            }
            logger.error((Object)"Create TongWeb websocket failed");
            logger.error((Object)t);
            t.printStackTrace();
        }
    }
}

