/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket.pojo;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.ExceptionUtils;
import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.websocket.pojo.PojoMessageHandlerWholeBase;
import com.tongweb.web.websocket.pojo.PojoMethodMapping;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;

public abstract class PojoEndpointBase
extends Endpoint {
    private final Log log = LogFactory.getLog(PojoEndpointBase.class);
    private static final StringManager sm = StringManager.getManager(PojoEndpointBase.class);
    private Object pojo;
    private final Map<String, String> pathParameters;
    private PojoMethodMapping methodMapping;

    protected PojoEndpointBase(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    protected final void doOnOpen(Session session, EndpointConfig config) {
        PojoMethodMapping methodMapping = this.getMethodMapping();
        Object pojo = this.getPojo();
        for (MessageHandler mh : methodMapping.getMessageHandlers(pojo, this.pathParameters, session, config)) {
            session.addMessageHandler(mh);
        }
        if (methodMapping.getOnOpen() != null) {
            try {
                methodMapping.getOnOpen().invoke(pojo, methodMapping.getOnOpenArgs(this.pathParameters, session, config));
            }
            catch (IllegalAccessException e) {
                this.log.error(sm.getString("pojoEndpointBase.onOpenFail", pojo.getClass().getName()), e);
                this.handleOnOpenOrCloseError(session, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                this.handleOnOpenOrCloseError(session, cause);
            }
            catch (Throwable t) {
                this.handleOnOpenOrCloseError(session, t);
            }
        }
    }

    private void handleOnOpenOrCloseError(Session session, Throwable t) {
        ExceptionUtils.handleThrowable(t);
        this.onError(session, t);
        try {
            session.close();
        }
        catch (IOException ioe) {
            this.log.warn(sm.getString("pojoEndpointBase.closeSessionFail"), ioe);
        }
    }

    public final void onClose(Session session, CloseReason closeReason) {
        if (this.methodMapping.getOnClose() != null) {
            try {
                this.methodMapping.getOnClose().invoke(this.pojo, this.methodMapping.getOnCloseArgs(this.pathParameters, session, closeReason));
            }
            catch (Throwable t) {
                this.log.error(sm.getString("pojoEndpointBase.onCloseFail", this.pojo.getClass().getName()), t);
                this.handleOnOpenOrCloseError(session, t);
            }
        }
        Set messageHandlers = session.getMessageHandlers();
        for (MessageHandler messageHandler : messageHandlers) {
            if (!(messageHandler instanceof PojoMessageHandlerWholeBase)) continue;
            ((PojoMessageHandlerWholeBase)messageHandler).onClose();
        }
    }

    public final void onError(Session session, Throwable throwable) {
        if (this.methodMapping.getOnError() == null) {
            this.log.error(sm.getString("pojoEndpointBase.onError", this.pojo.getClass().getName()), throwable);
        } else {
            try {
                this.methodMapping.getOnError().invoke(this.pojo, this.methodMapping.getOnErrorArgs(this.pathParameters, session, throwable));
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.log.error(sm.getString("pojoEndpointBase.onErrorFail", this.pojo.getClass().getName()), t);
            }
        }
    }

    protected Object getPojo() {
        return this.pojo;
    }

    protected void setPojo(Object pojo) {
        this.pojo = pojo;
    }

    protected PojoMethodMapping getMethodMapping() {
        return this.methodMapping;
    }

    protected void setMethodMapping(PojoMethodMapping methodMapping) {
        this.methodMapping = methodMapping;
    }
}

