/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.naming.factory;

import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimePartDataSource;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SendMailFactory
implements ObjectFactory {
    protected static final String DataSourceClassName = "jakarta.mail.internet.MimePartDataSource";

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context ctx, Hashtable<?, ?> env) throws Exception {
        Reference ref = (Reference)refObj;
        if (ref.getClassName().equals(DataSourceClassName)) {
            return AccessController.doPrivileged(() -> {
                Properties props = new Properties();
                Enumeration<RefAddr> list = ref.getAll();
                props.put("mail.transport.protocol", "smtp");
                while (list.hasMoreElements()) {
                    RefAddr refaddr = list.nextElement();
                    props.put(refaddr.getType(), refaddr.getContent());
                }
                MimeMessage message = new MimeMessage(Session.getInstance((Properties)props));
                try {
                    RefAddr fromAddr = ref.get("mail.from");
                    String from = null;
                    if (fromAddr != null) {
                        from = (String)ref.get("mail.from").getContent();
                    }
                    if (from != null) {
                        message.setFrom(new InternetAddress(from));
                    }
                    message.setSubject("");
                }
                catch (Exception fromAddr) {
                    // empty catch block
                }
                MimePartDataSource mds = new MimePartDataSource((MimePart)message);
                return mds;
            });
        }
        return null;
    }
}

