/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http11.upgrade;

import com.tongweb.connector.http11.upgrade.UpgradeInfo;
import com.tongweb.web.util.modeler.BaseModelMBean;
import java.util.ArrayList;
import java.util.List;

public class UpgradeGroupInfo
extends BaseModelMBean {
    private final List<UpgradeInfo> upgradeInfos = new ArrayList<UpgradeInfo>();
    private long deadBytesReceived = 0L;
    private long deadBytesSent = 0L;
    private long deadMsgsReceived = 0L;
    private long deadMsgsSent = 0L;

    public synchronized void addUpgradeInfo(UpgradeInfo ui) {
        this.upgradeInfos.add(ui);
    }

    public synchronized void removeUpgradeInfo(UpgradeInfo ui) {
        if (ui != null) {
            this.deadBytesReceived += ui.getBytesReceived();
            this.deadBytesSent += ui.getBytesSent();
            this.deadMsgsReceived += ui.getMsgsReceived();
            this.deadMsgsSent += ui.getMsgsSent();
            this.upgradeInfos.remove(ui);
        }
    }

    public synchronized long getBytesReceived() {
        long bytes = this.deadBytesReceived;
        for (UpgradeInfo ui : this.upgradeInfos) {
            bytes += ui.getBytesReceived();
        }
        return bytes;
    }

    public synchronized void setBytesReceived(long bytesReceived) {
        this.deadBytesReceived = bytesReceived;
        for (UpgradeInfo ui : this.upgradeInfos) {
            ui.setBytesReceived(bytesReceived);
        }
    }

    public synchronized long getBytesSent() {
        long bytes = this.deadBytesSent;
        for (UpgradeInfo ui : this.upgradeInfos) {
            bytes += ui.getBytesSent();
        }
        return bytes;
    }

    public synchronized void setBytesSent(long bytesSent) {
        this.deadBytesSent = bytesSent;
        for (UpgradeInfo ui : this.upgradeInfos) {
            ui.setBytesSent(bytesSent);
        }
    }

    public synchronized long getMsgsReceived() {
        long msgs = this.deadMsgsReceived;
        for (UpgradeInfo ui : this.upgradeInfos) {
            msgs += ui.getMsgsReceived();
        }
        return msgs;
    }

    public synchronized void setMsgsReceived(long msgsReceived) {
        this.deadMsgsReceived = msgsReceived;
        for (UpgradeInfo ui : this.upgradeInfos) {
            ui.setMsgsReceived(msgsReceived);
        }
    }

    public synchronized long getMsgsSent() {
        long msgs = this.deadMsgsSent;
        for (UpgradeInfo ui : this.upgradeInfos) {
            msgs += ui.getMsgsSent();
        }
        return msgs;
    }

    public synchronized void setMsgsSent(long msgsSent) {
        this.deadMsgsSent = msgsSent;
        for (UpgradeInfo ui : this.upgradeInfos) {
            ui.setMsgsSent(msgsSent);
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setMsgsReceived(0L);
        this.setMsgsSent(0L);
    }
}

