/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.valves;

import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.Response;
import com.tongweb.container.util.NetMask;
import com.tongweb.container.valves.RequestFilterValve;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RemoteCIDRValve
extends RequestFilterValve {
    private static final Log log = LogFactory.getLog(RemoteCIDRValve.class);
    private final List<NetMask> allow = new ArrayList<NetMask>();
    private final List<NetMask> deny = new ArrayList<NetMask>();

    @Override
    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    @Override
    public void setAllow(String input) {
        List<String> messages = this.fillFromInput(input, this.allow);
        if (messages.isEmpty()) {
            return;
        }
        this.allowValid = false;
        for (String message : messages) {
            log.error(message);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", "allow"));
    }

    @Override
    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    @Override
    public void setDeny(String input) {
        List<String> messages = this.fillFromInput(input, this.deny);
        if (messages.isEmpty()) {
            return;
        }
        this.denyValid = false;
        for (String message : messages) {
            log.error(message);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrValve.invalid", "deny"));
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Object property = this.getUsePeerAddress() ? request.getPeerAddr() : request.getRequest().getRemoteAddr();
        if (this.getAddConnectorPort()) {
            property = (String)property + ";" + request.getConnector().getPortWithOffset();
        }
        this.process((String)property, request, response);
    }

    @Override
    public boolean isAllowed(String property) {
        InetAddress addr;
        String nonPortPart;
        int port;
        int portIdx = property.indexOf(59);
        if (portIdx == -1) {
            if (this.getAddConnectorPort()) {
                log.error(sm.getString("remoteCidrValve.noPort"));
                return false;
            }
            port = -1;
            nonPortPart = property;
        } else {
            if (!this.getAddConnectorPort()) {
                log.error(sm.getString("remoteCidrValve.unexpectedPort"));
                return false;
            }
            nonPortPart = property.substring(0, portIdx);
            try {
                port = Integer.parseInt(property.substring(portIdx + 1));
            }
            catch (NumberFormatException e) {
                log.error(sm.getString("remoteCidrValve.noPort"), e);
                return false;
            }
        }
        try {
            addr = InetAddress.getByName(nonPortPart);
        }
        catch (UnknownHostException e) {
            log.error(sm.getString("remoteCidrValve.noRemoteIp"), e);
            return false;
        }
        for (NetMask nm : this.deny) {
            if (!(this.getAddConnectorPort() ? nm.matches(addr, port) : nm.matches(addr))) continue;
            return false;
        }
        for (NetMask nm : this.allow) {
            if (!(this.getAddConnectorPort() ? nm.matches(addr, port) : nm.matches(addr))) continue;
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private List<String> fillFromInput(String input, List<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (String s : input.split("\\s*,\\s*")) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add((CallSite)((Object)(s + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(messages);
    }
}

