/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.container.Context;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.util.SessionConfig;
import com.tongweb.web.util.res.StringManager;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.Cookie;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class ApplicationSessionCookieConfig
implements SessionCookieConfig {
    private static final StringManager sm = StringManager.getManager(ApplicationSessionCookieConfig.class);
    private static final int DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = false;
    private static final boolean DEFAULT_SECURE = false;
    private final Map<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private String name;
    private StandardContext context;

    public ApplicationSessionCookieConfig(StandardContext context) {
        this.context = context;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public String getDomain() {
        return this.getAttribute("Domain");
    }

    @Override
    public int getMaxAge() {
        String maxAge = this.getAttribute("Max-Age");
        if (maxAge == null) {
            return -1;
        }
        return Integer.parseInt(maxAge);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.getAttribute("Path");
    }

    @Override
    public boolean isHttpOnly() {
        String httpOnly = this.getAttribute("HttpOnly");
        if (httpOnly == null) {
            return false;
        }
        return Boolean.parseBoolean(httpOnly);
    }

    @Override
    public boolean isSecure() {
        String secure = this.getAttribute("Secure");
        if (secure == null) {
            return false;
        }
        return Boolean.parseBoolean(secure);
    }

    @Override
    public void setComment(String comment) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "comment", this.context.getPath()));
        }
    }

    @Override
    public void setDomain(String domain) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "domain name", this.context.getPath()));
        }
        this.setAttribute("Domain", domain);
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "HttpOnly", this.context.getPath()));
        }
        this.setAttribute("HttpOnly", Boolean.toString(httpOnly));
    }

    @Override
    public void setMaxAge(int maxAge) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "max age", this.context.getPath()));
        }
        this.setAttribute("Max-Age", Integer.toString(maxAge));
    }

    @Override
    public void setName(String name) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "name", this.context.getPath()));
        }
        this.name = name;
    }

    @Override
    public void setPath(String path) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "path", this.context.getPath()));
        }
        this.setAttribute("Path", path);
    }

    @Override
    public void setSecure(boolean secure) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", "secure", this.context.getPath()));
        }
        this.setAttribute("Secure", Boolean.toString(secure));
    }

    @Override
    public void setAttribute(String name, String value) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString("applicationSessionCookieConfig.ise", name, this.context.getPath()));
        }
        this.attributes.put(name, value);
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public static Cookie createSessionCookie(Context context, String sessionId, boolean secure) {
        SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
        Cookie cookie = new Cookie(SessionConfig.getSessionCookieName(context), sessionId);
        cookie.setMaxAge(scc.getMaxAge());
        if (context.getSessionCookieDomain() == null) {
            if (scc.getDomain() != null) {
                cookie.setDomain(scc.getDomain());
            }
        } else {
            cookie.setDomain(context.getSessionCookieDomain());
        }
        if (scc.isSecure() || secure) {
            cookie.setSecure(true);
        }
        if (scc.isHttpOnly() || context.getUseHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        cookie.setPath(SessionConfig.getSessionCookiePath(context));
        block11: for (Map.Entry<String, String> attribute : scc.getAttributes().entrySet()) {
            switch (attribute.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": {
                    continue block11;
                }
            }
            cookie.setAttribute(attribute.getKey(), attribute.getValue());
        }
        return cookie;
    }
}

