/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

public enum StorageClass {
    Standard("STANDARD"),
    ReducedRedundancy("REDUCED_REDUNDANCY"),
    Glacier("GLACIER"),
    StandardInfrequentAccess("STANDARD_IA"),
    OneZoneInfrequentAccess("ONEZONE_IA"),
    IntelligentTiering("INTELLIGENT_TIERING"),
    DeepArchive("DEEP_ARCHIVE");

    private final String storageClassId;

    public static StorageClass fromValue(String s3StorageClassString) throws IllegalArgumentException {
        StorageClass[] storageClassArray = StorageClass.values();
        int n = storageClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            StorageClass storageClass = storageClassArray[n2];
            if (storageClass.toString().equals(s3StorageClassString)) {
                return storageClass;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Cannot create enum from " + s3StorageClassString + " value!");
    }

    private StorageClass(String id) {
        this.storageClassId = id;
    }

    public String toString() {
        return this.storageClassId;
    }
}

