/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

public enum SSEAlgorithm {
    AES256("AES256"),
    KMS("aws:kms");

    private final String algorithm;

    public String getAlgorithm() {
        return this.algorithm;
    }

    private SSEAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String toString() {
        return this.algorithm;
    }

    public static SSEAlgorithm fromString(String algorithm) {
        if (algorithm == null) {
            return null;
        }
        SSEAlgorithm[] sSEAlgorithmArray = SSEAlgorithm.values();
        int n = sSEAlgorithmArray.length;
        int n2 = 0;
        while (n2 < n) {
            SSEAlgorithm e = sSEAlgorithmArray[n2];
            if (e.getAlgorithm().equals(algorithm)) {
                return e;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unsupported algorithm " + algorithm);
    }

    public static SSEAlgorithm getDefault() {
        return AES256;
    }
}

