/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.web.embedded.tongweb;

import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.Service;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.naming.ContextBindings;
import com.tongweb.springboot.web.embedded.tongweb.ConnectorStartFailedException;
import com.tongweb.springboot.web.embedded.tongweb.GracefulShutdown;
import com.tongweb.springboot.web.embedded.tongweb.TongWebEmbeddedContext;
import com.tongweb.springboot.web.embedded.tongweb.TongWebEmbeddedWebappClassLoader;
import com.tongweb.springboot.web.embedded.tongweb.TongWebStarter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.GracefulShutdownCallback;
import org.springframework.boot.web.server.GracefulShutdownResult;
import org.springframework.boot.web.server.PortInUseException;
import org.springframework.boot.web.server.Shutdown;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.Assert;

public class TongWebWebServer
implements WebServer {
    private static final Log logger = LogFactory.getLog(TongWebWebServer.class);
    private static final AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Object monitor = new Object();
    private final Map<Service, Connector[]> serviceConnectors = new HashMap<Service, Connector[]>();
    private final ServletContainer servletContainer;
    private final boolean autoStart;
    private final GracefulShutdown gracefulShutdown;
    private volatile boolean started;

    public TongWebWebServer(ServletContainer servletContainer) {
        this(servletContainer, true);
    }

    public TongWebWebServer(ServletContainer servletContainer, boolean autoStart) {
        this(servletContainer, autoStart, Shutdown.IMMEDIATE);
    }

    public TongWebWebServer(ServletContainer servletContainer, boolean autoStart, Shutdown shutdown) {
        Assert.notNull((Object)servletContainer, (String)"TongWeb Server must not be null");
        this.servletContainer = servletContainer;
        this.autoStart = autoStart;
        this.gracefulShutdown = shutdown == Shutdown.GRACEFUL ? new GracefulShutdown(servletContainer) : null;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws WebServerException {
        logger.info((Object)("TongWeb initialized with port(s): " + this.getPortsDescription(false)));
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.addInstanceIdToEngineName();
                Context context = this.findContext();
                context.addLifecycleListener(event -> {
                    if (context.equals(event.getSource()) && "start".equals(event.getType())) {
                        this.removeServiceConnectors();
                    }
                });
                this.servletContainer.start();
                this.rethrowDeferredStartupExceptions();
                try {
                    ContextBindings.bindClassLoader((Object)context, (Object)context.getNamingToken(), (ClassLoader)this.getClass().getClassLoader());
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.startDaemonAwaitThread();
            }
            catch (Exception ex) {
                this.stopSilently();
                this.destroySilently();
                throw new WebServerException("Unable to start embedded TongWeb", (Throwable)ex);
            }
        }
    }

    private Context findContext() {
        for (Container child : this.servletContainer.getHost().findChildren()) {
            if (!(child instanceof Context)) continue;
            Context context = (Context)child;
            return context;
        }
        throw new IllegalStateException("The host does not contain a Context");
    }

    private void addInstanceIdToEngineName() {
        int instanceId = containerCounter.incrementAndGet();
        if (instanceId > 0) {
            Engine engine = this.servletContainer.getEngine();
            engine.setName(engine.getName() + "-" + instanceId);
        }
    }

    private void removeServiceConnectors() {
        for (Service service : this.servletContainer.getServer().findServices()) {
            Connector[] connectors = (Connector[])service.findConnectors().clone();
            this.serviceConnectors.put(service, connectors);
            for (Connector connector : connectors) {
                service.removeConnector(connector);
            }
        }
    }

    private void rethrowDeferredStartupExceptions() throws Exception {
        Container[] children;
        for (Container container : children = this.servletContainer.getHost().findChildren()) {
            Exception exception;
            TongWebEmbeddedContext embeddedContext;
            TongWebStarter tongWebStarter;
            if (container instanceof TongWebEmbeddedContext && (tongWebStarter = (embeddedContext = (TongWebEmbeddedContext)container).getStarter()) != null && (exception = tongWebStarter.getStartUpException()) != null) {
                throw exception;
            }
            if (LifecycleState.STARTED.equals((Object)container.getState())) continue;
            throw new IllegalStateException(container + " failed to start");
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread("container-" + containerCounter.get()){

            @Override
            public void run() {
                TongWebWebServer.this.servletContainer.getServer().await();
            }
        };
        awaitThread.setContextClassLoader(this.getClass().getClassLoader());
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                this.addPreviouslyRemovedConnectors();
                Connector connector = this.servletContainer.getConnector();
                if (connector != null && this.autoStart) {
                    this.performDeferredLoadOnStartup();
                }
                this.checkThatConnectorsHaveStarted();
                this.started = true;
                logger.info((Object)("TongWeb started on port(s): " + this.getPortsDescription(true) + " with context path '" + this.getContextPath() + "'"));
            }
            catch (ConnectorStartFailedException ex) {
                this.stopSilently();
                throw ex;
            }
            catch (Exception ex) {
                PortInUseException.throwIfPortBindingException((Exception)ex, () -> this.servletContainer.getConnector().getPort());
                throw new WebServerException("Unable to start embedded TongWeb server", (Throwable)ex);
            }
            finally {
                Context context = this.findContext();
                ContextBindings.unbindClassLoader((Object)context, (Object)context.getNamingToken(), (ClassLoader)this.getClass().getClassLoader());
            }
        }
    }

    private void checkThatConnectorsHaveStarted() {
        this.checkConnectorHasStarted(this.servletContainer.getConnector());
        for (Connector connector : this.servletContainer.getService().findConnectors()) {
            this.checkConnectorHasStarted(connector);
        }
    }

    private void checkConnectorHasStarted(Connector connector) {
        if (LifecycleState.FAILED.equals((Object)connector.getState())) {
            throw new ConnectorStartFailedException(connector.getPort());
        }
    }

    private void stopSilently() {
        try {
            this.stopTongWeb();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void destroySilently() {
        try {
            this.servletContainer.destroy();
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    private void stopTongWeb() throws LifecycleException {
        if (Thread.currentThread().getContextClassLoader() instanceof TongWebEmbeddedWebappClassLoader) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
        this.servletContainer.stop();
    }

    private void addPreviouslyRemovedConnectors() {
        Service[] services;
        for (Service service : services = this.servletContainer.getServer().findServices()) {
            Connector[] connectors = this.serviceConnectors.get(service);
            if (connectors == null) continue;
            for (Connector connector : connectors) {
                service.addConnector(connector);
                if (this.autoStart) continue;
                this.stopProtocolHandler(connector);
            }
            this.serviceConnectors.remove(service);
        }
    }

    private void stopProtocolHandler(Connector connector) {
        try {
            connector.getProtocolHandler().stop();
        }
        catch (Exception ex) {
            logger.error((Object)"Cannot pause connector: ", (Throwable)ex);
        }
    }

    private void performDeferredLoadOnStartup() {
        try {
            for (Container child : this.servletContainer.getHost().findChildren()) {
                if (!(child instanceof TongWebEmbeddedContext)) continue;
                TongWebEmbeddedContext embeddedContext = (TongWebEmbeddedContext)child;
                embeddedContext.deferredLoadOnStartup();
            }
        }
        catch (Exception ex) {
            if (ex instanceof WebServerException) {
                WebServerException webServerException = (WebServerException)ex;
                throw webServerException;
            }
            throw new WebServerException("Unable to start embedded TongWeb connectors", (Throwable)ex);
        }
    }

    Map<Service, Connector[]> getServiceConnectors() {
        return this.serviceConnectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws WebServerException {
        Object object = this.monitor;
        synchronized (object) {
            boolean wasStarted = this.started;
            try {
                this.started = false;
                try {
                    if (this.gracefulShutdown != null) {
                        this.gracefulShutdown.abort();
                    }
                    this.stopTongWeb();
                    this.servletContainer.destroy();
                }
                catch (LifecycleException lifecycleException) {
                    // empty catch block
                }
            }
            catch (Exception ex) {
                throw new WebServerException("Unable to stop embedded TongWeb", (Throwable)ex);
            }
            finally {
                if (wasStarted) {
                    containerCounter.decrementAndGet();
                }
            }
        }
    }

    private String getPortsDescription(boolean localPort) {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.servletContainer.getService().findConnectors()) {
            if (ports.length() != 0) {
                ports.append(' ');
            }
            int port = localPort ? connector.getLocalPort() : connector.getPort();
            ports.append(port).append(" (").append(connector.getScheme()).append(')');
        }
        return ports.toString();
    }

    public int getPort() {
        Connector connector = this.servletContainer.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return -1;
    }

    private String getContextPath() {
        return Arrays.stream(this.servletContainer.getHost().findChildren()).filter(TongWebEmbeddedContext.class::isInstance).map(TongWebEmbeddedContext.class::cast).map(StandardContext::getPath).collect(Collectors.joining(" "));
    }

    public ServletContainer getTongWeb() {
        return this.servletContainer;
    }

    public void shutDownGracefully(GracefulShutdownCallback callback) {
        if (this.gracefulShutdown == null) {
            callback.shutdownComplete(GracefulShutdownResult.IMMEDIATE);
            return;
        }
        this.gracefulShutdown.shutDownGracefully(callback);
    }
}

