/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web.servlet;

import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebContextCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebServletWebServerFactory;
import jakarta.servlet.Servlet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.web.servlet.server.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class TongWebServletWebServerFactoryConfiguration {
    TongWebServletWebServerFactoryConfiguration() {
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, ServletContainer.class, UpgradeProtocol.class})
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    static class EmbeddedTongWeb {
        EmbeddedTongWeb() {
        }

        @Bean
        TongWebServletWebServerFactory tongWebServletWebServerFactory(ObjectProvider<TongWebConnectorCustomizer> connectorCustomizers, ObjectProvider<TongWebContextCustomizer> contextCustomizers, ObjectProvider<TongWebProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
            TongWebServletWebServerFactory factory = new TongWebServletWebServerFactory();
            factory.getTongWebConnectorCustomizers().addAll(connectorCustomizers.orderedStream().toList());
            factory.getTongWebContextCustomizers().addAll(contextCustomizers.orderedStream().toList());
            factory.getTongWebProtocolHandlerCustomizers().addAll(protocolHandlerCustomizers.orderedStream().toList());
            return factory;
        }
    }
}

