/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web;

import com.tongweb.springboot.autoconfigure.web.TongWebConfig;
import java.net.InetAddress;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.Http2;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="server", ignoreUnknownFields=true)
public class ServerProperties {
    @NestedConfigurationProperty
    private final ErrorProperties error = new ErrorProperties();
    @NestedConfigurationProperty
    private final Compression compression = new Compression();
    @NestedConfigurationProperty
    private final Http2 http2 = new Http2();
    private final Servlet servlet = new Servlet();
    @NestedConfigurationProperty
    private final TongWebConfig tongweb = new TongWebConfig();
    private final Netty netty = new Netty();
    private Integer port = 8088;
    private InetAddress address;
    private ForwardHeadersStrategy forwardHeadersStrategy;
    private String serverHeader;
    private int maxHttpHeaderSize = 0;
    private Duration connectionTimeout;
    @NestedConfigurationProperty
    private Ssl ssl;

    public Netty getNetty() {
        return this.netty;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    @DeprecatedConfigurationProperty(reason="Replaced to support additional strategies.", replacement="server.forward-headers-strategy")
    @Deprecated
    public Boolean isUseForwardHeaders() {
        return ForwardHeadersStrategy.NATIVE.equals((Object)this.forwardHeadersStrategy);
    }

    @Deprecated
    public void setUseForwardHeaders(Boolean useForwardHeaders) {
        this.forwardHeadersStrategy = Boolean.TRUE.equals(useForwardHeaders) ? ForwardHeadersStrategy.NATIVE : ForwardHeadersStrategy.NONE;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        this.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Each server behaves differently. Use server specific properties instead.")
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Deprecated
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public ErrorProperties getError() {
        return this.error;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public Http2 getHttp2() {
        return this.http2;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public TongWebConfig getTongweb() {
        return this.tongweb;
    }

    public ForwardHeadersStrategy getForwardHeadersStrategy() {
        return this.forwardHeadersStrategy;
    }

    public void setForwardHeadersStrategy(ForwardHeadersStrategy forwardHeadersStrategy) {
        this.forwardHeadersStrategy = forwardHeadersStrategy;
    }

    public static class Servlet {
        private final Map<String, String> contextParameters = new HashMap<String, String>();
        @NestedConfigurationProperty
        private final Jsp jsp = new Jsp();
        @NestedConfigurationProperty
        private final Session session = new Session();
        private String contextPath;
        private String applicationDisplayName = "application";

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private String cleanContextPath(String contextPath) {
            String candidate = StringUtils.trimWhitespace((String)contextPath);
            if (StringUtils.hasText((String)candidate) && candidate.endsWith("/")) {
                return candidate.substring(0, candidate.length() - 1);
            }
            return candidate;
        }

        public String getApplicationDisplayName() {
            return this.applicationDisplayName;
        }

        public void setApplicationDisplayName(String displayName) {
            this.applicationDisplayName = displayName;
        }

        public Map<String, String> getContextParameters() {
            return this.contextParameters;
        }

        public Jsp getJsp() {
            return this.jsp;
        }

        public Session getSession() {
            return this.session;
        }
    }

    public static class Netty {
        private Duration connectionTimeout;

        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }
    }

    public static enum ForwardHeadersStrategy {
        NATIVE,
        FRAMEWORK,
        NONE;

    }
}

