/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.actuate.metrics.web.tongweb;

import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Manager;
import com.tongweb.springboot.actuate.instrument.binder.tongweb.TongWebMetrics;
import com.tongweb.springboot.web.embedded.tongweb.TongWebWebServer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Collections;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class TongWebMetricsBinder
implements ApplicationListener<ApplicationStartedEvent>,
DisposableBean {
    private final MeterRegistry meterRegistry;
    private final Iterable<Tag> tags;
    private volatile TongWebMetrics tongWebMetrics;

    public TongWebMetricsBinder(MeterRegistry meterRegistry) {
        this(meterRegistry, Collections.emptyList());
    }

    public TongWebMetricsBinder(MeterRegistry meterRegistry, Iterable<Tag> tags) {
        this.meterRegistry = meterRegistry;
        this.tags = tags;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Manager manager = this.findManager((ApplicationContext)applicationContext);
        this.tongWebMetrics = new TongWebMetrics(manager, this.tags);
        this.tongWebMetrics.bindTo(this.meterRegistry);
    }

    private Manager findManager(ApplicationContext applicationContext) {
        TongWebWebServer tongWebWebServer;
        Context context;
        WebServerApplicationContext webServerApplicationContext;
        WebServer webServer;
        if (applicationContext instanceof WebServerApplicationContext && (webServer = (webServerApplicationContext = (WebServerApplicationContext)applicationContext).getWebServer()) instanceof TongWebWebServer && (context = this.findContext(tongWebWebServer = (TongWebWebServer)webServer)) != null) {
            return context.getManager();
        }
        return null;
    }

    private Context findContext(TongWebWebServer tongWebWebServer) {
        for (Container container : tongWebWebServer.getTongWeb().getHost().findChildren()) {
            if (!(container instanceof Context)) continue;
            Context context = (Context)container;
            return context;
        }
        return null;
    }

    public void destroy() {
        if (this.tongWebMetrics != null) {
            this.tongWebMetrics.close();
        }
    }
}

