/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.web.embedded.tongweb;

import com.tongweb.commons.license.LicenseSDKProvider;
import com.tongweb.commons.utils.SystemExitUtil;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Valve;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.AprLifecycleListener;
import com.tongweb.container.loader.WebappClassLoaderBase;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.util.ServerInfo;
import com.tongweb.springboot.autoconfigure.web.ServerProperties;
import com.tongweb.springboot.autoconfigure.web.TongWebConfig;
import com.tongweb.springboot.web.embedded.tongweb.CompressionConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.ConfigurableTongWebWebServerFactory;
import com.tongweb.springboot.web.embedded.tongweb.DisableReferenceClearingContextCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.SslConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebContextCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebEmbeddedContext;
import com.tongweb.springboot.web.embedded.tongweb.TongWebEmbeddedWebappClassLoader;
import com.tongweb.springboot.web.embedded.tongweb.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebWebServer;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import jakarta.servlet.Servlet;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.boot.web.server.WebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.TongWebHttpHandlerAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class TongWebReactiveWebServerFactory
extends AbstractReactiveWebServerFactory
implements ConfigurableTongWebWebServerFactory {
    @Autowired
    private ApplicationContext context;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String DEFAULT_PROTOCOL = "com.tongweb.connector.http11.Http11NioProtocol";
    private File baseDirectory;
    private final List<Valve> engineValves = new ArrayList<Valve>();
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private final List<LifecycleListener> serverLifecycleListeners = TongWebReactiveWebServerFactory.getDefaultServerLifecycleListeners();
    private Set<TongWebContextCustomizer> tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>();
    private Set<TongWebConnectorCustomizer> tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>();
    private Set<TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizers = new LinkedHashSet();
    private final List<Connector> additionalTongWebConnectors = new ArrayList<Connector>();
    private String protocol = "com.tongweb.connector.http11.Http11NioProtocol";
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;
    private boolean disableMBeanRegistry = true;
    private TongWebConfig tongWebConfig;

    public TongWebReactiveWebServerFactory() {
    }

    public TongWebReactiveWebServerFactory(int port) {
        super(port);
    }

    private static List<LifecycleListener> getDefaultServerLifecycleListeners() {
        AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
        return AprLifecycleListener.isAprAvailable() ? new ArrayList<AprLifecycleListener>(Arrays.asList(aprLifecycleListener)) : new ArrayList();
    }

    public WebServer getWebServer(HttpHandler httpHandler) {
        this.checkLicense();
        if (this.disableMBeanRegistry) {
            Registry.disableRegistry();
        }
        ServletContainer servletContainer = new ServletContainer();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tongweb");
        servletContainer.setBaseDir(baseDir.getAbsolutePath());
        for (LifecycleListener lifecycleListener : this.serverLifecycleListeners) {
            servletContainer.getServer().addLifecycleListener(lifecycleListener);
        }
        Connector connector = new Connector(this.protocol);
        connector.setThrowOnFailure(true);
        servletContainer.getService().addConnector(connector);
        this.customizeConnector(connector);
        servletContainer.setConnector(connector);
        servletContainer.getHost().setAutoDeploy(false);
        this.configureEngine(servletContainer.getEngine());
        for (Connector additionalConnector : this.additionalTongWebConnectors) {
            servletContainer.getService().addConnector(additionalConnector);
        }
        TongWebHttpHandlerAdapter tongWebHttpHandlerAdapter = new TongWebHttpHandlerAdapter(httpHandler);
        this.prepareContext(servletContainer.getHost(), tongWebHttpHandlerAdapter);
        return this.getTongWebWebServer(servletContainer);
    }

    private void checkLicense() {
        ServerInfo.getServerENumber();
        SystemExitUtil.setHook(() -> System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0})));
        PropertyMapper propertyMapper = PropertyMapper.get();
        String validType = this.tongWebConfig.getLicense().getType();
        String licensePath = this.tongWebConfig.getLicense().getPath();
        Boolean isSync = this.tongWebConfig.getLicense().isSync();
        System.setProperty("server.tongweb.license.type", validType);
        System.setProperty("server.tongweb.license.filePath", licensePath);
        System.setProperty("server.tongweb.license.isSync", isSync.toString());
        propertyMapper.from((Object)this.tongWebConfig.getLicense().getLicenseIps()).whenHasText().to(this::putLicenseIps);
        propertyMapper.from((Object)this.tongWebConfig.getLicense().getLicensePublicKey()).whenHasText().to(this::putPublicKey);
        Optional.of(this.tongWebConfig.getLicense().getSsl()).ifPresent(ssl -> {
            propertyMapper.from((Object)this.tongWebConfig.getLicense().isSslEnabled()).whenNonNull().to(this::pusSslEnabled);
            propertyMapper.from((Object)ssl.getKeyStore()).whenHasText().to(this::putKeyStore);
            propertyMapper.from((Object)ssl.getKeyStorePassword()).whenHasText().to(this::putKeyStorePassword);
            propertyMapper.from((Object)ssl.getKeyStoreType()).whenHasText().to(this::putKeyStoreType);
            propertyMapper.from((Object)ssl.getTrustStore()).whenHasText().to(this::putTrustStore);
            propertyMapper.from((Object)ssl.getTrustStorePassword()).whenHasText().to(this::putTrustStorePassword);
            propertyMapper.from((Object)ssl.getTrustStoreType()).whenHasText().to(this::putTrustStoreType);
        });
        LicenseSDKProvider.validate();
    }

    private void putLicenseIps(String value) {
        System.setProperty("server.tongweb.license.license-ips", value);
    }

    private void putPublicKey(String value) {
        System.setProperty("server.tongweb.license.publicKey", value);
    }

    private void pusSslEnabled(boolean value) {
        System.setProperty("server.tongweb.license.ssl.enabled", String.valueOf(value));
    }

    private void putKeyStore(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStore", value);
    }

    private void putKeyStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStorePassword", value);
    }

    private void putKeyStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStoreType", value);
    }

    private void putTrustStore(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStore", value);
    }

    private void putTrustStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStorePassword", value);
    }

    private void putTrustStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStoreType", value);
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, TongWebHttpHandlerAdapter servlet) {
        File docBase = this.createTempDir("tongweb-docbase");
        TongWebEmbeddedContext context = new TongWebEmbeddedContext();
        context.setPath("");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new ServletContainer.FixContextListener());
        ClassLoader parentClassLoader = ClassUtils.getDefaultClassLoader();
        context.setParentClassLoader(parentClassLoader);
        this.skipAllTldScanning(context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderInstance((WebappClassLoaderBase)new TongWebEmbeddedWebappClassLoader(parentClassLoader));
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        ServletContainer.addServlet((Context)context, (String)"httpHandlerServlet", (Servlet)servlet).setAsyncSupported(true);
        context.addServletMappingDecoded("/", "httpHandlerServlet");
        host.addChild((Container)context);
        this.configureContext((Context)context);
    }

    private void skipAllTldScanning(TongWebEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip("*.jar");
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    protected void configureContext(Context context) {
        this.contextLifecycleListeners.forEach(arg_0 -> ((Context)context).addLifecycleListener(arg_0));
        new DisableReferenceClearingContextCustomizer().customize(context);
        this.tongWebContextCustomizers.forEach(customizer -> customizer.customize(context));
    }

    protected void customizeConnector(Connector connector) {
        int port = Math.max(this.getPort(), 0);
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setProperty("server", this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        this.invokeProtocolHandlerCustomizers(connector.getProtocolHandler());
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.getCompression());
        compression.customize(connector);
        for (TongWebConnectorCustomizer customizer : this.tongWebConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    private void invokeProtocolHandlerCustomizers(ProtocolHandler protocolHandler) {
        LambdaSafe.callbacks(TongWebProtocolHandlerCustomizer.class, this.tongWebProtocolHandlerCustomizers, (Object)protocolHandler, (Object[])new Object[0]).invoke(customizer -> customizer.customize(protocolHandler));
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getOrCreateSslStoreProvider()).customize(connector);
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public void setTongWebContextCustomizers(Collection<? extends TongWebContextCustomizer> tongWebContextCustomizers) {
        Assert.notNull(tongWebContextCustomizers, (String)"TongWebContextCustomizers must not be null");
        this.tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>(tongWebContextCustomizers);
    }

    public Collection<TongWebContextCustomizer> getTongWebContextCustomizers() {
        return this.tongWebContextCustomizers;
    }

    @Override
    public void addContextCustomizers(TongWebContextCustomizer ... tongWebContextCustomizers) {
        Assert.notNull((Object)tongWebContextCustomizers, (String)"TongWebContextCustomizers must not be null");
        this.tongWebContextCustomizers.addAll(Arrays.asList(tongWebContextCustomizers));
    }

    public void setTongWebConnectorCustomizers(Collection<? extends TongWebConnectorCustomizer> tongWebConnectorCustomizers) {
        Assert.notNull(tongWebConnectorCustomizers, (String)"TongWebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>(tongWebConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(TongWebConnectorCustomizer ... tongWebConnectorCustomizers) {
        Assert.notNull((Object)tongWebConnectorCustomizers, (String)"TongWebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers.addAll(Arrays.asList(tongWebConnectorCustomizers));
    }

    public Collection<TongWebConnectorCustomizer> getTongWebConnectorCustomizers() {
        return this.tongWebConnectorCustomizers;
    }

    public void setTongWebProtocolHandlerCustomizers(Collection<? extends TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizers) {
        Assert.notNull(tongWebProtocolHandlerCustomizers, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers = new LinkedHashSet(tongWebProtocolHandlerCustomizers);
    }

    @Override
    public void addProtocolHandlerCustomizers(TongWebProtocolHandlerCustomizer<?> ... tongWebProtocolHandlerCustomizers) {
        Assert.notNull(tongWebProtocolHandlerCustomizers, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers.addAll(Arrays.asList(tongWebProtocolHandlerCustomizers));
    }

    public Collection<TongWebProtocolHandlerCustomizer<?>> getTongWebProtocolHandlerCustomizers() {
        return this.tongWebProtocolHandlerCustomizers;
    }

    public void addAdditionalTongWebConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalTongWebConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalTongWebConnectors() {
        return this.additionalTongWebConnectors;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public List<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    @Override
    public void setServerProperties(ServerProperties serverProperties) {
        this.tongWebConfig = serverProperties.getTongweb();
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    protected TongWebWebServer getTongWebWebServer(ServletContainer servletContainer) {
        return new TongWebWebServer(servletContainer, this.getPort() >= 0, this.getShutdown());
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        this.disableMBeanRegistry = disableMBeanRegistry;
    }
}

