/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtils {
    public static final String PATTER_yyyy_MM_dd = "yyyy-MM-dd";

    public static boolean isAfterNow(String dateStr, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(dateStr);
        return date.after(new Date());
    }

    public static boolean isAfterNow(String dateStr) throws ParseException {
        return DateUtils.isAfterNow(dateStr, PATTER_yyyy_MM_dd);
    }

    public static boolean isBeforeNow(String dateStr, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(dateStr);
        return date.before(new Date());
    }

    public static boolean isBeforeNow(String dateStr) throws ParseException {
        return DateUtils.isBeforeNow(dateStr, PATTER_yyyy_MM_dd);
    }

    public static boolean isAfterBuffer(String dateStr, int bufferDays, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(dateStr);
        long dateStamp = date.getTime();
        long endTimeAndBufferTime = dateStamp + (long)(bufferDays * 86400 * 1000);
        long currentTime = System.currentTimeMillis();
        return currentTime > endTimeAndBufferTime;
    }

    public static boolean isNearExpire(String dateStr, int bufferDays, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = sdf.parse(dateStr);
        long dateStamp = date.getTime();
        long endTimeAndBufferTime = dateStamp + (long)(bufferDays * 86400 * 1000);
        long currentTime = System.currentTimeMillis();
        return currentTime > endTimeAndBufferTime;
    }

    public static long distanceDays(String date1, String date2, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date firstDate = sdf.parse(date1);
        Date secondDate = sdf.parse(date2);
        Double result = Math.ceil((double)(firstDate.getTime() - secondDate.getTime()) / 8.64E7);
        return result.longValue();
    }

    public static long distanceDays(String date1, String date2) throws ParseException {
        return DateUtils.distanceDays(date1, date2, PATTER_yyyy_MM_dd);
    }

    public static long distanceTodayDays(String date1) throws ParseException {
        return DateUtils.distanceTodayDays(date1, PATTER_yyyy_MM_dd);
    }

    public static long distanceTodayDays(String date1, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date firstDate = sdf.parse(date1);
        Date secondDate = new Date();
        Double result = Math.ceil((double)(firstDate.getTime() - secondDate.getTime()) / 8.64E7);
        return result.longValue();
    }

    public static String format(Long date, String format) {
        return DateUtils.format(new Date(date), format);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public static String format(Long date) {
        return DateUtils.format(new Date(date));
    }

    public static String format(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(date);
    }

    public static Date parse(String date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(date);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static Date parseDefault(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return dateFormat.parse(date);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

