/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.tianfu.json.internal.bind;

import com.tongweb.tianfu.json.Json;
import com.tongweb.tianfu.json.TypeAdapter;
import com.tongweb.tianfu.json.TypeAdapterFactory;
import com.tongweb.tianfu.json.internal.LinkedTreeMap;
import com.tongweb.tianfu.json.reflect.TypeToken;
import com.tongweb.tianfu.json.stream.JsonReader;
import com.tongweb.tianfu.json.stream.JsonToken;
import com.tongweb.tianfu.json.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class ObjectTypeAdapter
extends TypeAdapter<Object> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Json json, TypeToken<T> type) {
            if (type.getRawType() == Object.class) {
                return new ObjectTypeAdapter(json);
            }
            return null;
        }
    };
    private final Json json;

    ObjectTypeAdapter(Json json) {
        this.json = json;
    }

    @Override
    public Object read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(this.read(in));
                }
                in.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedTreeMap<String, Object> map = new LinkedTreeMap<String, Object>();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), this.read(in));
                }
                in.endObject();
                return map;
            }
            case STRING: {
                return in.nextString();
            }
            case NUMBER: {
                double dbNum = in.nextDouble();
                if (dbNum > 9.223372036854776E18) {
                    return dbNum;
                }
                long lngNum = (long)dbNum;
                if (dbNum == (double)lngNum) {
                    try {
                        return (int)lngNum;
                    }
                    catch (Exception e2) {
                        return lngNum;
                    }
                }
                return dbNum;
            }
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(JsonWriter out, Object value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        TypeAdapter<?> typeAdapter = this.json.getAdapter(value.getClass());
        if (typeAdapter instanceof ObjectTypeAdapter) {
            out.beginObject();
            out.endObject();
            return;
        }
        typeAdapter.write(out, value);
    }
}

