/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.tianfu.json;

import com.tongweb.tianfu.json.DefaultDateTypeAdapter;
import com.tongweb.tianfu.json.ExclusionStrategy;
import com.tongweb.tianfu.json.FieldNamingPolicy;
import com.tongweb.tianfu.json.FieldNamingStrategy;
import com.tongweb.tianfu.json.InstanceCreator;
import com.tongweb.tianfu.json.Json;
import com.tongweb.tianfu.json.JsonDeserializer;
import com.tongweb.tianfu.json.JsonSerializer;
import com.tongweb.tianfu.json.LongSerializationPolicy;
import com.tongweb.tianfu.json.TypeAdapter;
import com.tongweb.tianfu.json.TypeAdapterFactory;
import com.tongweb.tianfu.json.internal.$Json$Preconditions;
import com.tongweb.tianfu.json.internal.Excluder;
import com.tongweb.tianfu.json.internal.bind.TreeTypeAdapter;
import com.tongweb.tianfu.json.internal.bind.TypeAdapters;
import com.tongweb.tianfu.json.reflect.TypeToken;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JsonBuilder {
    private Excluder excluder = Excluder.DEFAULT;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
    private final List<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>();
    private boolean serializeNulls = false;
    private String datePattern;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean complexMapKeySerialization = false;
    private boolean serializeSpecialFloatingPointValues = false;
    private boolean escapeHtmlChars = true;
    private boolean prettyPrinting = false;
    private boolean generateNonExecutableJson = false;
    private boolean lenient = false;

    public JsonBuilder() {
    }

    JsonBuilder(Json json) {
        this.excluder = json.excluder;
        this.fieldNamingPolicy = json.fieldNamingStrategy;
        this.instanceCreators.putAll(json.instanceCreators);
        this.serializeNulls = json.serializeNulls;
        this.complexMapKeySerialization = json.complexMapKeySerialization;
        this.generateNonExecutableJson = json.generateNonExecutableJson;
        this.escapeHtmlChars = json.htmlSafe;
        this.prettyPrinting = json.prettyPrinting;
        this.lenient = json.lenient;
        this.serializeSpecialFloatingPointValues = json.serializeSpecialFloatingPointValues;
        this.longSerializationPolicy = json.longSerializationPolicy;
        this.datePattern = json.datePattern;
        this.dateStyle = json.dateStyle;
        this.timeStyle = json.timeStyle;
        this.factories.addAll(json.builderFactories);
        this.hierarchyFactories.addAll(json.builderHierarchyFactories);
    }

    public JsonBuilder setVersion(double ignoreVersionsAfter) {
        this.excluder = this.excluder.withVersion(ignoreVersionsAfter);
        return this;
    }

    public JsonBuilder excludeFieldsWithModifiers(int ... modifiers) {
        this.excluder = this.excluder.withModifiers(modifiers);
        return this;
    }

    public JsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    public JsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excluder = this.excluder.excludeFieldsWithoutExposeAnnotation();
        return this;
    }

    public JsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    public JsonBuilder enableComplexMapKeySerialization() {
        this.complexMapKeySerialization = true;
        return this;
    }

    public JsonBuilder disableInnerClassSerialization() {
        this.excluder = this.excluder.disableInnerClassSerialization();
        return this;
    }

    public JsonBuilder setLongSerializationPolicy(LongSerializationPolicy serializationPolicy) {
        this.longSerializationPolicy = serializationPolicy;
        return this;
    }

    public JsonBuilder setFieldNamingPolicy(FieldNamingPolicy namingConvention) {
        this.fieldNamingPolicy = namingConvention;
        return this;
    }

    public JsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = fieldNamingStrategy;
        return this;
    }

    public JsonBuilder setExclusionStrategies(ExclusionStrategy ... strategies) {
        for (ExclusionStrategy strategy : strategies) {
            this.excluder = this.excluder.withExclusionStrategy(strategy, true, true);
        }
        return this;
    }

    public JsonBuilder addSerializationExclusionStrategy(ExclusionStrategy strategy) {
        this.excluder = this.excluder.withExclusionStrategy(strategy, true, false);
        return this;
    }

    public JsonBuilder addDeserializationExclusionStrategy(ExclusionStrategy strategy) {
        this.excluder = this.excluder.withExclusionStrategy(strategy, false, true);
        return this;
    }

    public JsonBuilder setPrettyPrinting() {
        this.prettyPrinting = true;
        return this;
    }

    public JsonBuilder setLenient() {
        this.lenient = true;
        return this;
    }

    public JsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    public JsonBuilder setDateFormat(String pattern) {
        this.datePattern = pattern;
        return this;
    }

    public JsonBuilder setDateFormat(int style) {
        this.dateStyle = style;
        this.datePattern = null;
        return this;
    }

    public JsonBuilder setDateFormat(int dateStyle, int timeStyle) {
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
        this.datePattern = null;
        return this;
    }

    public JsonBuilder registerTypeAdapter(Type type, Object typeAdapter) {
        $Json$Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof InstanceCreator || typeAdapter instanceof TypeAdapter);
        if (typeAdapter instanceof InstanceCreator) {
            this.instanceCreators.put(type, (InstanceCreator)typeAdapter);
        }
        if (typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer) {
            TypeToken<?> typeToken = TypeToken.get(type);
            this.factories.add(TreeTypeAdapter.newFactoryWithMatchRawType(typeToken, typeAdapter));
        }
        if (typeAdapter instanceof TypeAdapter) {
            this.factories.add(TypeAdapters.newFactory(TypeToken.get(type), (TypeAdapter)typeAdapter));
        }
        return this;
    }

    public JsonBuilder registerTypeAdapterFactory(TypeAdapterFactory factory) {
        this.factories.add(factory);
        return this;
    }

    public JsonBuilder registerTypeHierarchyAdapter(Class<?> baseType, Object typeAdapter) {
        $Json$Preconditions.checkArgument(typeAdapter instanceof JsonSerializer || typeAdapter instanceof JsonDeserializer || typeAdapter instanceof TypeAdapter);
        if (typeAdapter instanceof JsonDeserializer || typeAdapter instanceof JsonSerializer) {
            this.hierarchyFactories.add(TreeTypeAdapter.newTypeHierarchyFactory(baseType, typeAdapter));
        }
        if (typeAdapter instanceof TypeAdapter) {
            this.factories.add(TypeAdapters.newTypeHierarchyFactory(baseType, (TypeAdapter)typeAdapter));
        }
        return this;
    }

    public JsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    public Json create() {
        ArrayList<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>(this.factories.size() + this.hierarchyFactories.size() + 3);
        factories.addAll(this.factories);
        Collections.reverse(factories);
        ArrayList<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>(this.hierarchyFactories);
        Collections.reverse(hierarchyFactories);
        factories.addAll(hierarchyFactories);
        this.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, factories);
        return new Json(this.excluder, this.fieldNamingPolicy, this.instanceCreators, this.serializeNulls, this.complexMapKeySerialization, this.generateNonExecutableJson, this.escapeHtmlChars, this.prettyPrinting, this.lenient, this.serializeSpecialFloatingPointValues, this.longSerializationPolicy, this.datePattern, this.dateStyle, this.timeStyle, this.factories, this.hierarchyFactories, factories);
    }

    private void addTypeAdaptersForDate(String datePattern, int dateStyle, int timeStyle, List<TypeAdapterFactory> factories) {
        DefaultDateTypeAdapter javaSqlDateTypeAdapter;
        DefaultDateTypeAdapter timestampTypeAdapter;
        DefaultDateTypeAdapter dateTypeAdapter;
        if (datePattern != null && !"".equals(datePattern.trim())) {
            dateTypeAdapter = new DefaultDateTypeAdapter(java.util.Date.class, datePattern);
            timestampTypeAdapter = new DefaultDateTypeAdapter(Timestamp.class, datePattern);
            javaSqlDateTypeAdapter = new DefaultDateTypeAdapter(Date.class, datePattern);
        } else if (dateStyle != 2 && timeStyle != 2) {
            dateTypeAdapter = new DefaultDateTypeAdapter(java.util.Date.class, dateStyle, timeStyle);
            timestampTypeAdapter = new DefaultDateTypeAdapter(Timestamp.class, dateStyle, timeStyle);
            javaSqlDateTypeAdapter = new DefaultDateTypeAdapter(Date.class, dateStyle, timeStyle);
        } else {
            return;
        }
        factories.add(TypeAdapters.newFactory(java.util.Date.class, dateTypeAdapter));
        factories.add(TypeAdapters.newFactory(Timestamp.class, timestampTypeAdapter));
        factories.add(TypeAdapters.newFactory(Date.class, javaSqlDateTypeAdapter));
    }
}

