/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http2;

import com.tongweb.connector.Response;
import com.tongweb.connector.http11.HttpOutputBuffer;
import com.tongweb.connector.http11.OutputFilter;
import com.tongweb.connector.http2.Stream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Http2OutputBuffer
implements HttpOutputBuffer {
    private final Response coyoteResponse;
    private HttpOutputBuffer next;

    public void addFilter(OutputFilter filter) {
        filter.setBuffer(this.next);
        this.next = filter;
    }

    public Http2OutputBuffer(Response coyoteResponse, Stream.StreamOutputBuffer streamOutputBuffer) {
        this.coyoteResponse = coyoteResponse;
        this.next = streamOutputBuffer;
    }

    @Override
    public int doWrite(ByteBuffer chunk) throws IOException {
        if (!this.coyoteResponse.isCommitted()) {
            this.coyoteResponse.sendHeaders();
        }
        return this.next.doWrite(chunk);
    }

    @Override
    public long getBytesWritten() {
        return this.next.getBytesWritten();
    }

    @Override
    public void end() throws IOException {
        this.next.end();
    }

    @Override
    public void flush() throws IOException {
        this.next.flush();
    }
}

