/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.el.parser;

import com.tongweb.el.lang.EvaluationContext;
import com.tongweb.el.parser.SimpleNode;
import jakarta.el.ELException;
import java.math.BigDecimal;

public final class AstFloatingPoint
extends SimpleNode {
    private volatile Number number;

    public AstFloatingPoint(int id) {
        super(id);
    }

    public Number getFloatingPoint() {
        if (this.number == null) {
            try {
                Double d = Double.valueOf(this.image);
                this.number = d.isInfinite() || d.isNaN() ? new BigDecimal(this.image) : d;
            }
            catch (NumberFormatException e) {
                throw new ELException(e);
            }
        }
        return this.number;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        return this.getFloatingPoint();
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        return this.getFloatingPoint().getClass();
    }
}

