/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.valves;

import com.tongweb.connector.ActionCode;
import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.Response;
import com.tongweb.container.valves.ErrorReportValve;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.ExceptionUtils;
import com.tongweb.web.util.descriptor.web.ErrorPage;
import com.tongweb.web.util.http.fileupload.IOUtils;
import com.tongweb.web.util.res.StringManager;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProxyErrorReportValve
extends ErrorReportValve {
    private static final Log log = LogFactory.getLog(ProxyErrorReportValve.class);
    protected boolean useRedirect = true;
    protected boolean usePropertiesFile = false;

    public boolean getUseRedirect() {
        return this.useRedirect;
    }

    public void setUseRedirect(boolean useRedirect) {
        this.useRedirect = useRedirect;
    }

    public boolean getUsePropertiesFile() {
        return this.usePropertiesFile;
    }

    public void setUsePropertiesFile(boolean usePropertiesFile) {
        this.usePropertiesFile = usePropertiesFile;
    }

    private String getRedirectUrl(Response response) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.getClass().getSimpleName(), response.getLocale());
        String redirectUrl = null;
        try {
            redirectUrl = resourceBundle.getString(Integer.toString(response.getStatus()));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (redirectUrl == null) {
            try {
                redirectUrl = resourceBundle.getString(Integer.toString(0));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return redirectUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void report(Request request, Response response, Throwable throwable) {
        int statusCode = response.getStatus();
        if (statusCode < 400 || response.getContentWritten() > 0L) {
            return;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, result);
        if (!result.get()) {
            return;
        }
        String urlString = null;
        if (this.usePropertiesFile) {
            urlString = this.getRedirectUrl(response);
        } else {
            ErrorPage errorPage = this.findErrorPage(statusCode, throwable);
            if (errorPage != null) {
                urlString = errorPage.getLocation();
            }
        }
        if (urlString == null) {
            super.report(request, response, throwable);
            return;
        }
        if (!response.setErrorReported()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(urlString);
        if (urlString.indexOf("?") > -1) {
            stringBuilder.append('&');
        } else {
            stringBuilder.append('?');
        }
        stringBuilder.append("requestUri=");
        stringBuilder.append(URLEncoder.encode(request.getDecodedRequestURI(), request.getConnector().getURICharset()));
        stringBuilder.append("&statusCode=");
        stringBuilder.append(URLEncoder.encode(String.valueOf(statusCode), StandardCharsets.UTF_8));
        String reason = null;
        String description = null;
        StringManager smClient = StringManager.getManager("com.tongweb.container.valves", request.getLocales());
        response.setLocale(smClient.getLocale());
        try {
            reason = smClient.getString("http." + statusCode + ".reason");
            description = smClient.getString("http." + statusCode + ".desc");
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        if (reason == null || description == null) {
            reason = smClient.getString("errorReportValve.unknownReason");
            description = smClient.getString("errorReportValve.noDescription");
        }
        stringBuilder.append("&statusDescription=");
        stringBuilder.append(URLEncoder.encode(description, StandardCharsets.UTF_8));
        stringBuilder.append("&statusReason=");
        stringBuilder.append(URLEncoder.encode(reason, StandardCharsets.UTF_8));
        String message = response.getMessage();
        if (message != null) {
            stringBuilder.append("&message=");
            stringBuilder.append(URLEncoder.encode(message, StandardCharsets.UTF_8));
        }
        if (throwable != null) {
            stringBuilder.append("&throwable=");
            stringBuilder.append(URLEncoder.encode(throwable.toString(), StandardCharsets.UTF_8));
        }
        urlString = stringBuilder.toString();
        if (this.useRedirect) {
            if (log.isTraceEnabled()) {
                log.trace("Redirecting error reporting to " + urlString);
            }
            try {
                response.sendRedirect(urlString);
            }
            catch (IOException iOException) {}
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Proxying error reporting to " + urlString);
            }
            HttpURLConnection httpURLConnection = null;
            try {
                URL url = new URI(urlString).toURL();
                httpURLConnection = (HttpURLConnection)url.openConnection();
                httpURLConnection.connect();
                response.setContentType(httpURLConnection.getContentType());
                response.setContentLength(httpURLConnection.getContentLength());
                ServletOutputStream outputStream = response.getOutputStream();
                InputStream inputStream = url.openStream();
                IOUtils.copy(inputStream, outputStream);
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Proxy error to " + urlString, e);
                }
            }
            finally {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
    }
}

