/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import com.tongweb.commons.utils.SerializableUtils;
import com.tongweb.commons.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpUtils {
    private final String CTYPE_FORM = "application/x-www-form-urlencoded;charset=utf-8";
    private final String CTYPE_JSON = "application/json; charset=utf-8";
    private final String charset = "utf-8";
    private List<String> whiteDeserializeClassNameList = null;
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    @Deprecated
    public static HttpUtils getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static HttpUtils getInstance(List whiteDeserializeClassNameList) {
        if (whiteDeserializeClassNameList != null) {
            SingletonHolder.INSTANCE.whiteDeserializeClassNameList = whiteDeserializeClassNameList;
        }
        return SingletonHolder.INSTANCE;
    }

    public String postJson(String url, String jsonContent) throws SocketTimeoutException, IOException {
        return this.doRequest("POST", url, jsonContent, 15000, 15000, "application/json; charset=utf-8", null, null, null);
    }

    public String postJson(String url, String jsonContent, KeyManager[] km, TrustManager[] tm) throws SocketTimeoutException, IOException {
        return this.doRequest("POST", url, jsonContent, 15000, 15000, "application/json; charset=utf-8", null, km, tm);
    }

    public String postJson(String url, String jsonContent, Map<String, String> headerMap, KeyManager[] km, TrustManager[] tm) throws SocketTimeoutException, IOException {
        return this.doRequest("POST", url, jsonContent, 15000, 15000, "application/json; charset=utf-8", headerMap, km, tm);
    }

    public String postForm(String url) throws SocketTimeoutException, IOException {
        return this.doRequest("POST", url, "", 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, null, null);
    }

    public String postForm(String url, Map<String, String> params) throws SocketTimeoutException, IOException {
        return this.doRequest("POST", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, null, null);
    }

    public String getForm(String url) throws SocketTimeoutException, IOException {
        return this.doRequest("GET", url, "", 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, null, null);
    }

    public Object postFormObject(String url, Map<String, String> params) throws IOException, ClassNotFoundException {
        return this.doRequestObject("POST", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, null, null);
    }

    public Object postFormObject(String url, Map<String, String> params, KeyManager[] km) throws IOException, ClassNotFoundException {
        return this.doRequestObject("POST", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, km, null);
    }

    public Object postFormObject(String url, Map<String, String> params, KeyManager[] km, TrustManager[] tm) throws IOException, ClassNotFoundException {
        return this.doRequestObject("POST", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, km, tm);
    }

    public String getString(String url) throws IOException, ClassNotFoundException {
        return this.doRequest("GET", url, "", 15000, 15000, "application/json; charset=utf-8", null, null, null);
    }

    public String getString(String url, KeyManager[] km, TrustManager[] tm) throws IOException, ClassNotFoundException {
        return this.doRequest("GET", url, "", 15000, 15000, "application/json; charset=utf-8", null, km, tm);
    }

    public String getString(String url, Map<String, String> headerMap, KeyManager[] km, TrustManager[] tm) throws IOException, ClassNotFoundException {
        return this.doRequest("GET", url, "", 15000, 15000, "application/json; charset=utf-8", headerMap, km, tm);
    }

    public Object get(String url) throws IOException, ClassNotFoundException {
        return this.doRequestObject("GET", url, "", 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, null, null);
    }

    private Object doRequestObject(String method, String url, String requestContent, int connectTimeout, int readTimeout, String ctype, Map<String, String> headerMap, KeyManager[] km, TrustManager[] tm) throws IOException, ClassNotFoundException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            InputStream es;
            conn = this.getConnection(new URL(url), method, ctype, headerMap, km, tm);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (!StringUtils.isEmpty(requestContent)) {
                out = conn.getOutputStream();
                out.write(requestContent.getBytes("utf-8"));
            }
            if ((es = conn.getErrorStream()) == null) {
                Object object = SerializableUtils.deserialize(conn.getInputStream(), this.whiteDeserializeClassNameList);
                return object;
            }
            String msg = this.doTransformString(es, "utf-8");
            if (StringUtils.isEmpty(msg)) {
                throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
            }
            throw new IOException(conn.getResponseCode() + ":" + msg);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
            conn = null;
        }
    }

    public String getForm(String url, Map<String, String> params) throws SocketTimeoutException, IOException {
        return this.doRequest("GET", url, this.buildQuery(params), 15000, 15000, "application/x-www-form-urlencoded;charset=utf-8", null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRequest(String method, String url, String requestContent, int connectTimeout, int readTimeout, String ctype, Map<String, String> headerMap, KeyManager[] km, TrustManager[] tm) throws SocketTimeoutException, IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        try {
            conn = this.getConnection(new URL(url), method, ctype, headerMap, km, tm);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (!StringUtils.isEmpty(requestContent)) {
                out = conn.getOutputStream();
                out.write(requestContent.getBytes("utf-8"));
            }
            rsp = this.getResponseAsString(conn);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
            conn = null;
        }
        return rsp;
    }

    private static SSLSocketFactory configSSl(HttpsURLConnection connection, KeyManager[] km, TrustManager[] tm) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(km, tm == null ? trustAllCerts : tm, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return oldFactory;
    }

    private HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, KeyManager[] km, TrustManager[] tm) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            HttpUtils.configSSl(connHttps, km, tm);
            connHttps.setHostnameVerifier(DO_NOT_VERIFY);
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return this.doTransformString(conn.getInputStream(), "utf-8");
        }
        String msg = this.doTransformString(es, "utf-8");
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * Loose catch block
     */
    private String doTransformString(InputStream stream, String charset) throws IOException {
        try {
            try (InputStreamReader reader = new InputStreamReader(stream, charset);){
                StringBuilder response = new StringBuilder();
                char[] buff = new char[1024];
                int read = 0;
                while ((read = reader.read(buff)) > 0) {
                    response.append(buff, 0, read);
                }
                String string = response.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String buildQuery(Map<String, String> params) throws IOException {
        String str = "";
        if (params == null || params.isEmpty()) {
            return "";
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            if (value != null) {
                query.append(name).append("=").append(URLEncoder.encode(value, "utf-8"));
            }
            if (!query.toString().endsWith("&")) continue;
            str = query.toString().substring(0, query.toString().length() - 1);
        }
        return query.toString();
    }

    private static class SingletonHolder {
        private static final HttpUtils INSTANCE = new HttpUtils();

        private SingletonHolder() {
        }
    }
}

