/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.buildutil;

import com.tongweb.web.buildutil.Utils;
import com.tongweb.web.util.descriptor.DigesterFactory;
import com.tongweb.web.util.descriptor.XmlErrorHandler;
import com.tongweb.web.util.descriptor.web.WebRuleSet;
import com.tongweb.web.util.descriptor.web.WebXml;
import com.tongweb.web.util.digester.Digester;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.InputSource;

public class MimeTypeMappings {
    public static void main(String ... args) throws Exception {
        InputSource globalWebXml = new InputSource(new File("conf/web.xml").getAbsoluteFile().toURI().toString());
        WebXml webXmlDefaultFragment = new WebXml();
        webXmlDefaultFragment.setOverridable(true);
        webXmlDefaultFragment.setDistributable(true);
        webXmlDefaultFragment.setAlwaysAddWelcomeFiles(false);
        Digester digester = DigesterFactory.newDigester(true, true, new WebRuleSet(), true);
        XmlErrorHandler handler = new XmlErrorHandler();
        digester.setErrorHandler(handler);
        digester.push(webXmlDefaultFragment);
        digester.parse(globalWebXml);
        Map<String, String> webXmlMimeMappings = webXmlDefaultFragment.getMimeMappings();
        TreeMap<String, String> sortedWebXmlMimeMappings = new TreeMap<String, String>(webXmlMimeMappings);
        File f = new File("java/com/tongweb/container/startup/MimeTypeMappings.properties");
        FileOutputStream fos = new FileOutputStream(f);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.US_ASCII);
        Utils.insertLicense(w);
        w.write(System.lineSeparator());
        for (Map.Entry mapping : sortedWebXmlMimeMappings.entrySet()) {
            w.write((String)mapping.getKey());
            w.write("=");
            w.write((String)mapping.getValue());
            w.write(System.lineSeparator());
        }
        ((Writer)w).close();
        fos.close();
    }
}

