/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.authenticator.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.List;
import javax.security.auth.Subject;

public class SimpleServerAuthContext
implements ServerAuthContext {
    private final List<ServerAuthModule> modules;

    public SimpleServerAuthContext(List<ServerAuthModule> modules) {
        this.modules = modules;
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        for (int moduleIndex = 0; moduleIndex < this.modules.size(); ++moduleIndex) {
            ServerAuthModule module = this.modules.get(moduleIndex);
            AuthStatus result = module.validateRequest(messageInfo, clientSubject, serviceSubject);
            if (result == AuthStatus.SEND_FAILURE) continue;
            messageInfo.getMap().put("moduleIndex", moduleIndex);
            return result;
        }
        return AuthStatus.SEND_FAILURE;
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        ServerAuthModule module = this.modules.get((Integer)messageInfo.getMap().get("moduleIndex"));
        return module.secureResponse(messageInfo, serviceSubject);
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        for (ServerAuthModule module : this.modules) {
            module.cleanSubject(messageInfo, subject);
        }
    }
}

