/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.math.BigDecimal;

public class NUMBER {
    private final double MAX_INT_DOUBLE = 2.147483647E9;
    private final double MIN_INT_DOUBLE = -2.147483648E9;
    private final double MAX_SHORT_DOUBLE = 32767.0;
    private final double MIN_SHORT_DOUBLE = -32768.0;
    private final double MAX_BYTE_DOUBLE = 127.0;
    private final double MIN_BYTE_DOUBLE = -128.0;
    private final double MAX_LONG_DOUBLE = 9.223372036854776E18;
    private final double MIN_LONG_DOUBLE = -9.223372036854776E18;
    private final double MAX_FLOAT_DOUBLE = Math.pow(2.0, 128.0);
    private final double MIN_FLOAT_DOUBLE = -Math.pow(2.0, 128.0);
    private int type;
    private Object data;

    public NUMBER(byte data) {
        this.type = -6;
        this.data = data;
    }

    public NUMBER(short data) {
        this.type = 5;
        this.data = data;
    }

    public NUMBER(int data) {
        this.type = 4;
        this.data = data;
    }

    public NUMBER(long data) {
        this.type = -5;
        this.data = data;
    }

    public NUMBER(BigDecimal data) {
        this.type = 3;
        this.data = data;
    }

    public NUMBER(float data) {
        this.type = 7;
        this.data = Float.valueOf(data);
    }

    public NUMBER(double data) {
        this.type = 8;
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public long toLong() {
        if (this.type == 2 || this.type == 3) {
            BigDecimal mid = (BigDecimal)this.data;
            if (mid.compareTo(new BigDecimal(9.223372036854776E18)) == 1 || mid.compareTo(new BigDecimal(-2.147483648E9)) == 0) {
                throw new RuntimeException("the result is too large to change into java.lang.Long");
            }
            return mid.longValue();
        }
        if (this.type == 7) {
            float mid = ((Float)this.data).floatValue();
            if ((double)mid > 9.223372036854776E18 || (double)mid < -9.223372036854776E18) {
                throw new RuntimeException("the result is too large to change into java.lang.Long");
            }
            return (long)mid;
        }
        if (this.type == 6 || this.type == 8) {
            double mid = (Double)this.data;
            if (mid > 9.223372036854776E18 || mid < -9.223372036854776E18) {
                throw new RuntimeException("the result is too large to change into java.lang.Long");
            }
            return (long)mid;
        }
        if (this.type == -6) {
            return ((Byte)this.data).byteValue();
        }
        if (this.type == 5) {
            return ((Short)this.data).shortValue();
        }
        if (this.type == 4) {
            return ((Integer)this.data).intValue();
        }
        return (Long)this.data;
    }

    public int toInt() {
        if (this.type == 2 || this.type == 3) {
            BigDecimal mid = (BigDecimal)this.data;
            if (mid.compareTo(new BigDecimal(2.147483647E9)) == 1 || mid.compareTo(new BigDecimal(-2.147483648E9)) == 0) {
                throw new RuntimeException("the result is too large to change into java.lang.Integer");
            }
            return mid.intValue();
        }
        if (this.type == 7) {
            float mid = ((Float)this.data).floatValue();
            if ((double)mid > 2.147483647E9 || (double)mid < -2.147483648E9) {
                throw new RuntimeException("the result is too large to change into java.lang.Integer");
            }
            return (int)mid;
        }
        if (this.type == -5) {
            long mid = (Long)this.data;
            if ((double)mid > 2.147483647E9 || (double)mid < -2.147483648E9) {
                throw new RuntimeException("the result is too large to change into java.lang.Integer");
            }
            return (int)mid;
        }
        if (this.type == 6 || this.type == 8) {
            double mid = (Double)this.data;
            if (mid > 2.147483647E9 || mid < -2.147483648E9) {
                throw new RuntimeException("the result is too large to change into java.lang.Integer");
            }
            return (int)mid;
        }
        if (this.type == -6) {
            return ((Byte)this.data).byteValue();
        }
        if (this.type == 5) {
            return ((Short)this.data).shortValue();
        }
        return (Integer)this.data;
    }

    public short toShort() {
        if (this.type == 2 || this.type == 3) {
            BigDecimal mid = (BigDecimal)this.data;
            if (mid.compareTo(new BigDecimal(32767.0)) == 1 || mid.compareTo(new BigDecimal(-32768.0)) == 0) {
                throw new RuntimeException("the result is too large to change into java.lang.Short");
            }
            return mid.shortValue();
        }
        if (this.type == 7) {
            float mid = ((Float)this.data).floatValue();
            if ((double)mid > 32767.0 || (double)mid < -32768.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Short");
            }
            return (short)mid;
        }
        if (this.type == 6 || this.type == 8) {
            double mid = (Double)this.data;
            if (mid > 32767.0 || mid < -32768.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Short");
            }
            return (short)mid;
        }
        if (this.type == -5) {
            long mid = (Long)this.data;
            if ((double)mid > 9.223372036854776E18 || (double)mid < -9.223372036854776E18) {
                throw new RuntimeException("the result is too large to change into java.lang.Short");
            }
            return (short)mid;
        }
        if (this.type == 4) {
            int mid = (Integer)this.data;
            if ((double)mid > 2.147483647E9 || (double)mid < -2.147483648E9) {
                throw new RuntimeException("the result is too large to change into java.lang.Short");
            }
            return (short)mid;
        }
        if (this.type == -6) {
            return ((Byte)this.data).byteValue();
        }
        return (Short)this.data;
    }

    public byte toByte() {
        if (this.type == 2 || this.type == 3) {
            BigDecimal mid = (BigDecimal)this.data;
            if (mid.compareTo(new BigDecimal(127.0)) == 1 || mid.compareTo(new BigDecimal(-128.0)) == 0) {
                throw new RuntimeException("the result is too large to change into java.lang.Byte");
            }
            return mid.byteValue();
        }
        if (this.type == 7) {
            float mid = ((Float)this.data).floatValue();
            if ((double)mid > 127.0 || (double)mid < -128.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Byte");
            }
            return (byte)mid;
        }
        if (this.type == 6 || this.type == 8) {
            double mid = (Double)this.data;
            if (mid > 127.0 || mid < -128.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Byte");
            }
            return (byte)mid;
        }
        if (this.type == 5) {
            short mid = (Short)this.data;
            if ((double)mid > 127.0 || (double)mid < -128.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Byte");
            }
            return (byte)mid;
        }
        if (this.type == 4) {
            int mid = (Integer)this.data;
            if ((double)mid > 127.0 || (double)mid < -128.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Byte");
            }
            return (byte)mid;
        }
        if (this.type == -5) {
            long mid = (Long)this.data;
            if ((double)mid > 127.0 || (double)mid < -128.0) {
                throw new RuntimeException("the result is too large to change into java.lang.Byte");
            }
            return (byte)mid;
        }
        return (Byte)this.data;
    }

    public float toFloat() {
        double mid;
        if ((this.type == 6 || this.type == 8) && ((mid = ((Double)this.data).doubleValue()) > this.MAX_FLOAT_DOUBLE || mid < this.MIN_FLOAT_DOUBLE)) {
            throw new RuntimeException("the result is too large to change into java.lang.Float");
        }
        return Float.parseFloat(this.data.toString());
    }

    public double toDouble() {
        return Double.parseDouble(this.data.toString());
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.data.toString());
    }

    public String toString() {
        return this.data.toString();
    }
}

