/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import com.tongweb.container.connector.CoyoteInputStream;
import com.tongweb.container.connector.CoyoteOutputStream;
import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.RequestFacade;
import com.tongweb.container.connector.Response;
import com.tongweb.container.connector.ResponseFacade;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.http.server.reactive.TongWebHeadersAdapter;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

public class TongWebHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public TongWebHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    protected ServletServerHttpRequest createRequest(HttpServletRequest request, AsyncContext asyncContext) throws IOException, URISyntaxException {
        Assert.state((this.getServletPath() != null ? 1 : 0) != 0, (String)"Servlet path is not initialized");
        return new TongWebServerHttpRequest(request, asyncContext, this.getServletPath(), this.getDataBufferFactory(), this.getBufferSize());
    }

    protected ServletServerHttpResponse createResponse(HttpServletResponse response, AsyncContext asyncContext, ServletServerHttpRequest request) throws IOException {
        return new TongWebServerHttpResponse(response, asyncContext, this.getDataBufferFactory(), this.getBufferSize(), request);
    }

    private static final class TongWebServerHttpRequest
    extends ServletServerHttpRequest {
        private static final Field COYOTE_REQUEST_FIELD;
        private final int bufferSize;
        private final DataBufferFactory factory;

        TongWebServerHttpRequest(HttpServletRequest request, AsyncContext context, String servletPath, DataBufferFactory factory, int bufferSize) throws IOException, URISyntaxException {
            super(TongWebServerHttpRequest.createTongWebHttpHeaders(request), request, context, servletPath, factory, bufferSize);
            this.factory = factory;
            this.bufferSize = bufferSize;
        }

        private static MultiValueMap<String, String> createTongWebHttpHeaders(HttpServletRequest request) {
            RequestFacade requestFacade = TongWebServerHttpRequest.getRequestFacade(request);
            Request connectorRequest = (Request)ReflectionUtils.getField((Field)COYOTE_REQUEST_FIELD, (Object)requestFacade);
            Assert.state((connectorRequest != null ? 1 : 0) != 0, (String)"No TongWeb connector request");
            com.tongweb.connector.Request tongwebRequest = connectorRequest.getCoyoteRequest();
            return new TongWebHeadersAdapter(tongwebRequest.getMimeHeaders());
        }

        private static RequestFacade getRequestFacade(HttpServletRequest request) {
            if (request instanceof RequestFacade) {
                RequestFacade facade = (RequestFacade)request;
                return facade;
            }
            if (request instanceof HttpServletRequestWrapper) {
                HttpServletRequestWrapper wrapper = (HttpServletRequestWrapper)request;
                HttpServletRequest wrappedRequest = (HttpServletRequest)wrapper.getRequest();
                return TongWebServerHttpRequest.getRequestFacade(wrappedRequest);
            }
            throw new IllegalArgumentException("Cannot convert [" + request.getClass() + "] to org.apache.catalina.connector.RequestFacade");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DataBuffer readFromInputStream() throws IOException {
            ServletInputStream servletInputStream = this.getInputStream();
            if (servletInputStream instanceof CoyoteInputStream) {
                CoyoteInputStream coyoteInputStream = (CoyoteInputStream)servletInputStream;
                DataBuffer dataBuffer = this.factory.allocateBuffer(this.bufferSize);
                int read = -1;
                try {
                    DataBuffer dataBuffer2;
                    try (DataBuffer.ByteBufferIterator iterator = dataBuffer.writableByteBuffers();){
                        Assert.state((boolean)iterator.hasNext(), (String)"No ByteBuffer available");
                        ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                        read = coyoteInputStream.read(byteBuffer);
                    }
                    this.logBytesRead(read);
                    if (read > 0) {
                        dataBuffer.writePosition(read);
                        dataBuffer2 = dataBuffer;
                        return dataBuffer2;
                    }
                    if (read == -1) {
                        dataBuffer2 = EOF_BUFFER;
                        return dataBuffer2;
                    }
                    dataBuffer2 = AbstractListenerReadPublisher.EMPTY_BUFFER;
                    return dataBuffer2;
                }
                finally {
                    if (read <= 0) {
                        DataBufferUtils.release((DataBuffer)dataBuffer);
                    }
                }
            }
            return super.readFromInputStream();
        }

        static {
            Field field = ReflectionUtils.findField(RequestFacade.class, (String)"request");
            Assert.state((field != null ? 1 : 0) != 0, (String)"Incompatible TongWeb implementation");
            ReflectionUtils.makeAccessible((Field)field);
            COYOTE_REQUEST_FIELD = field;
        }
    }

    private static final class TongWebServerHttpResponse
    extends ServletServerHttpResponse {
        private static final Field COYOTE_RESPONSE_FIELD;

        TongWebServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize, ServletServerHttpRequest request) throws IOException {
            super(TongWebServerHttpResponse.createTongWebHttpHeaders(response), response, context, factory, bufferSize, request);
        }

        private static HttpHeaders createTongWebHttpHeaders(HttpServletResponse response) {
            ResponseFacade responseFacade = TongWebServerHttpResponse.getResponseFacade(response);
            Response connectorResponse = (Response)ReflectionUtils.getField((Field)COYOTE_RESPONSE_FIELD, (Object)responseFacade);
            Assert.state((connectorResponse != null ? 1 : 0) != 0, (String)"No TongWeb connector response");
            com.tongweb.connector.Response tongwebResponse = connectorResponse.getCoyoteResponse();
            TongWebHeadersAdapter headers = new TongWebHeadersAdapter(tongwebResponse.getMimeHeaders());
            return new HttpHeaders((MultiValueMap)headers);
        }

        private static ResponseFacade getResponseFacade(HttpServletResponse response) {
            if (response instanceof ResponseFacade) {
                ResponseFacade facade = (ResponseFacade)response;
                return facade;
            }
            if (response instanceof HttpServletResponseWrapper) {
                HttpServletResponseWrapper wrapper = (HttpServletResponseWrapper)response;
                HttpServletResponse wrappedResponse = (HttpServletResponse)wrapper.getResponse();
                return TongWebServerHttpResponse.getResponseFacade(wrappedResponse);
            }
            throw new IllegalArgumentException("Cannot convert [" + response.getClass() + "] to org.apache.catalina.connector.ResponseFacade");
        }

        protected void applyHeaders() {
            this.adaptHeaders(true);
        }

        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ServletOutputStream servletOutputStream = this.getOutputStream();
            if (servletOutputStream instanceof CoyoteOutputStream) {
                CoyoteOutputStream coyoteOutputStream = (CoyoteOutputStream)servletOutputStream;
                int len = 0;
                try (DataBuffer.ByteBufferIterator iterator = dataBuffer.readableByteBuffers();){
                    while (iterator.hasNext() && coyoteOutputStream.isReady()) {
                        ByteBuffer byteBuffer = (ByteBuffer)iterator.next();
                        len += byteBuffer.remaining();
                        coyoteOutputStream.write(byteBuffer);
                    }
                }
                return len;
            }
            return super.writeToOutputStream(dataBuffer);
        }

        static {
            Field field = ReflectionUtils.findField(ResponseFacade.class, (String)"response");
            Assert.state((field != null ? 1 : 0) != 0, (String)"Incompatible TongWeb implementation");
            ReflectionUtils.makeAccessible((Field)field);
            COYOTE_RESPONSE_FIELD = field;
        }
    }
}

