/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.web.embedded.tongweb;

import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.http11.AbstractHttp11Protocol;
import com.tongweb.container.connector.Connector;
import com.tongweb.springboot.web.embedded.tongweb.TongWebConnectorCustomizer;
import org.springframework.boot.web.server.Compression;
import org.springframework.util.StringUtils;

class CompressionConnectorCustomizer
implements TongWebConnectorCustomizer {
    private final Compression compression;

    CompressionConnectorCustomizer(Compression compression) {
        this.compression = compression;
    }

    @Override
    public void customize(Connector connector) {
        ProtocolHandler handler;
        if (this.compression != null && this.compression.getEnabled() && (handler = connector.getProtocolHandler()) instanceof AbstractHttp11Protocol) {
            this.customize((AbstractHttp11Protocol)handler);
        }
    }

    private void customize(AbstractHttp11Protocol<?> protocol) {
        Compression compression = this.compression;
        protocol.setCompression("on");
        protocol.setCompressionMinSize(this.getMinResponseSize(compression));
        protocol.setCompressibleMimeType(this.getMimeTypes(compression));
        if (this.compression.getExcludedUserAgents() != null) {
            protocol.setNoCompressionUserAgents(this.getExcludedUserAgents());
        }
    }

    private int getMinResponseSize(Compression compression) {
        return (int)compression.getMinResponseSize().toBytes();
    }

    private String getMimeTypes(Compression compression) {
        return StringUtils.arrayToCommaDelimitedString((Object[])compression.getMimeTypes());
    }

    private String getExcludedUserAgents() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.compression.getExcludedUserAgents());
    }
}

