/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web.servlet;

import com.tongweb.springboot.autoconfigure.web.ServerProperties;
import com.tongweb.springboot.autoconfigure.web.embedded.TongWebWebServerFactoryCustomizer;
import jakarta.servlet.ServletContext;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.ErrorPageRegistrarBeanPostProcessor;
import org.springframework.boot.web.server.WebServerFactoryCustomizerBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={ServerProperties.class})
@Import(value={BeanPostProcessorsRegistrar.class, ServletContextInitializer.class})
public class LiteTongWeb {
    @Bean
    public TongWebWebServerFactoryCustomizer tongWebPropertiesCustomizer(Environment env, ServerProperties tongWebProperties) {
        String language = tongWebProperties.getTongweb().getLanguage();
        String country = tongWebProperties.getTongweb().getCountry();
        if (StringUtils.isEmpty((Object)language)) {
            Locale.setDefault(Locale.US);
        } else {
            Locale.setDefault(new Locale(language, country));
        }
        return new TongWebWebServerFactoryCustomizer(env, tongWebProperties);
    }

    @Bean
    public Locale locale() {
        return Locale.CANADA;
    }

    @ConditionalOnBean(value={WebMvcConfigurationSupport.class})
    public static class ServletContextInitializer
    implements ServletContextAware {
        public List<WebMvcConfigurationSupport> list;

        public ServletContextInitializer(List<WebMvcConfigurationSupport> list) {
            this.list = list;
        }

        public void setServletContext(ServletContext servletContext) {
            for (WebMvcConfigurationSupport webMvcConfigurationSupport : this.list) {
                if (webMvcConfigurationSupport.getServletContext() != null) continue;
                webMvcConfigurationSupport.setServletContext(servletContext);
            }
        }
    }

    public static class BeanPostProcessorsRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private ConfigurableListableBeanFactory beanFactory;

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory == null) {
                return;
            }
            this.registerSyntheticBeanIfMissing(registry, "webServerFactoryCustomizerBeanPostProcessor", WebServerFactoryCustomizerBeanPostProcessor.class);
            this.registerSyntheticBeanIfMissing(registry, "errorPageRegistrarBeanPostProcessor", ErrorPageRegistrarBeanPostProcessor.class);
        }

        private void registerSyntheticBeanIfMissing(BeanDefinitionRegistry registry, String name, Class<?> beanClass) {
            if (ObjectUtils.isEmpty((Object[])this.beanFactory.getBeanNamesForType(beanClass, true, false))) {
                RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            }
        }
    }
}

