/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.web.embedded.tongweb;

import com.tongweb.container.Container;
import com.tongweb.container.Manager;
import com.tongweb.container.SessionIdGenerator;
import com.tongweb.container.Wrapper;
import com.tongweb.container.core.StandardContext;
import com.tongweb.container.core.StandardWrapper;
import com.tongweb.container.session.ManagerBase;
import com.tongweb.springboot.web.embedded.tongweb.LazySessionIdGenerator;
import com.tongweb.springboot.web.embedded.tongweb.TongWebStarter;
import jakarta.servlet.ServletException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ClassUtils;

class TongWebEmbeddedContext
extends StandardContext {
    private TongWebStarter starter;
    private MimeMappings mimeMappings;

    TongWebEmbeddedContext() {
    }

    public boolean loadOnStartup(Container[] children) {
        return true;
    }

    public void setManager(Manager manager) {
        if (manager instanceof ManagerBase) {
            manager.setSessionIdGenerator((SessionIdGenerator)new LazySessionIdGenerator());
        }
        super.setManager(manager);
    }

    void deferredLoadOnStartup() {
        this.doWithThreadContextClassLoader(this.getLoader().getClassLoader(), () -> this.getLoadOnStartupWrappers(this.findChildren()).forEach(this::load));
    }

    private Stream<Wrapper> getLoadOnStartupWrappers(Container[] children) {
        TreeMap<Integer, List> grouped = new TreeMap<Integer, List>();
        for (Container child : children) {
            Wrapper wrapper = (Wrapper)child;
            int order = wrapper.getLoadOnStartup();
            if (order < 0) continue;
            grouped.computeIfAbsent(order, o -> new ArrayList()).add(wrapper);
        }
        return grouped.values().stream().flatMap(Collection::stream);
    }

    private void load(Wrapper wrapper) {
        try {
            wrapper.load();
        }
        catch (ServletException ex) {
            String message = sm.getString("standardContext.loadOnStartup.loadException", new Object[]{this.getName(), wrapper.getName()});
            if (this.getComputedFailCtxIfServletStartFails()) {
                throw new WebServerException(message, (Throwable)ex);
            }
            this.getLogger().error((Object)message, StandardWrapper.getRootCause((ServletException)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithThreadContextClassLoader(ClassLoader classLoader, Runnable code) {
        ClassLoader existingLoader = classLoader != null ? ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader) : null;
        try {
            code.run();
        }
        finally {
            if (existingLoader != null) {
                ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
            }
        }
    }

    void setStarter(TongWebStarter starter) {
        this.starter = starter;
    }

    TongWebStarter getStarter() {
        return this.starter;
    }

    void setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = mimeMappings;
    }

    public String[] findMimeMappings() {
        ArrayList<String> mappings = new ArrayList<String>();
        mappings.addAll(Arrays.asList(super.findMimeMappings()));
        if (this.mimeMappings != null) {
            this.mimeMappings.forEach(mapping -> mappings.add(mapping.getExtension()));
        }
        return (String[])mappings.toArray(String[]::new);
    }

    public String findMimeMapping(String extension) {
        String mimeMapping = super.findMimeMapping(extension);
        if (mimeMapping != null) {
            return mimeMapping;
        }
        return this.mimeMappings != null ? this.mimeMappings.get(extension) : null;
    }
}

