/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.websocket;

import com.tongweb.web.InstanceManager;
import com.tongweb.web.util.res.StringManager;
import com.tongweb.web.websocket.ClientEndpointHolder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import javax.naming.NamingException;

public class EndpointHolder
implements ClientEndpointHolder {
    private static final StringManager sm = StringManager.getManager(EndpointHolder.class);
    private final Endpoint endpoint;

    public EndpointHolder(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String getClassName() {
        return this.endpoint.getClass().getName();
    }

    @Override
    public Endpoint getInstance(InstanceManager instanceManager) throws DeploymentException {
        if (instanceManager != null) {
            try {
                instanceManager.newInstance(this.endpoint);
            }
            catch (ReflectiveOperationException | NamingException e) {
                throw new DeploymentException(sm.getString("clientEndpointHolder.instanceRegistrationFailed"), (Throwable)e);
            }
        }
        return this.endpoint;
    }
}

